package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FindingAggregator(
    findingAggregatorArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.FindingAggregator = {
    import FindingAggregator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.FindingAggregator
      .builder()
      .optionallyWith(
        findingAggregatorArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.findingAggregatorArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.FindingAggregator.ReadOnly =
    zio.aws.securityhub.model.FindingAggregator.wrap(buildAwsValue())
}
object FindingAggregator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.FindingAggregator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.FindingAggregator =
      zio.aws.securityhub.model
        .FindingAggregator(findingAggregatorArn.map(value => value))
    def findingAggregatorArn: Option[NonEmptyString]
    def getFindingAggregatorArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("findingAggregatorArn", findingAggregatorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.FindingAggregator
  ) extends zio.aws.securityhub.model.FindingAggregator.ReadOnly {
    override val findingAggregatorArn: Option[NonEmptyString] = scala
      .Option(impl.findingAggregatorArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.FindingAggregator
  ): zio.aws.securityhub.model.FindingAggregator.ReadOnly = new Wrapper(impl)
}
