package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  MaxResults,
  NextToken,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStandardsControlsRequest(
    standardsSubscriptionArn: NonEmptyString,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest = {
    import DescribeStandardsControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
      .builder()
      .standardsSubscriptionArn(
        NonEmptyString.unwrap(standardsSubscriptionArn): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly =
    zio.aws.securityhub.model.DescribeStandardsControlsRequest
      .wrap(buildAwsValue())
}
object DescribeStandardsControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DescribeStandardsControlsRequest =
      zio.aws.securityhub.model.DescribeStandardsControlsRequest(
        standardsSubscriptionArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def standardsSubscriptionArn: NonEmptyString
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getStandardsSubscriptionArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(standardsSubscriptionArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ) extends zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly {
    override val standardsSubscriptionArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.standardsSubscriptionArn())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.securityhub.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.securityhub.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest
  ): zio.aws.securityhub.model.DescribeStandardsControlsRequest.ReadOnly =
    new Wrapper(impl)
}
