package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteActionTargetRequest(actionTargetArn: NonEmptyString) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest = {
    import DeleteActionTargetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest
      .builder()
      .actionTargetArn(NonEmptyString.unwrap(actionTargetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DeleteActionTargetRequest.ReadOnly =
    zio.aws.securityhub.model.DeleteActionTargetRequest.wrap(buildAwsValue())
}
object DeleteActionTargetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DeleteActionTargetRequest =
      zio.aws.securityhub.model.DeleteActionTargetRequest(actionTargetArn)
    def actionTargetArn: NonEmptyString
    def getActionTargetArn: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(actionTargetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest
  ) extends zio.aws.securityhub.model.DeleteActionTargetRequest.ReadOnly {
    override val actionTargetArn: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.actionTargetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest
  ): zio.aws.securityhub.model.DeleteActionTargetRequest.ReadOnly = new Wrapper(
    impl
  )
}
