package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Compliance(
    status: Option[zio.aws.securityhub.model.ComplianceStatus] = None,
    relatedRequirements: Option[Iterable[NonEmptyString]] = None,
    statusReasons: Option[Iterable[zio.aws.securityhub.model.StatusReason]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Compliance = {
    import Compliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Compliance
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        relatedRequirements.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.relatedRequirements)
      .optionallyWith(
        statusReasons.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusReasons)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Compliance.ReadOnly =
    zio.aws.securityhub.model.Compliance.wrap(buildAwsValue())
}
object Compliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Compliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Compliance =
      zio.aws.securityhub.model.Compliance(
        status.map(value => value),
        relatedRequirements.map(value => value),
        statusReasons.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def status: Option[zio.aws.securityhub.model.ComplianceStatus]
    def relatedRequirements: Option[List[NonEmptyString]]
    def statusReasons
        : Option[List[zio.aws.securityhub.model.StatusReason.ReadOnly]]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.ComplianceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRelatedRequirements: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("relatedRequirements", relatedRequirements)
    def getStatusReasons: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StatusReason.ReadOnly
    ]] = AwsError.unwrapOptionField("statusReasons", statusReasons)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Compliance
  ) extends zio.aws.securityhub.model.Compliance.ReadOnly {
    override val status: Option[zio.aws.securityhub.model.ComplianceStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.securityhub.model.ComplianceStatus.wrap(value))
    override val relatedRequirements: Option[List[NonEmptyString]] = scala
      .Option(impl.relatedRequirements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val statusReasons
        : Option[List[zio.aws.securityhub.model.StatusReason.ReadOnly]] = scala
      .Option(impl.statusReasons())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StatusReason.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Compliance
  ): zio.aws.securityhub.model.Compliance.ReadOnly = new Wrapper(impl)
}
