package zio.aws.securityhub.model
import java.lang.Integer
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, RatioScale}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchUpdateFindingsRequest(
    findingIdentifiers: Iterable[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier
    ],
    note: Option[zio.aws.securityhub.model.NoteUpdate] = None,
    severity: Option[zio.aws.securityhub.model.SeverityUpdate] = None,
    verificationState: Option[zio.aws.securityhub.model.VerificationState] =
      None,
    confidence: Option[RatioScale] = None,
    criticality: Option[RatioScale] = None,
    types: Option[Iterable[NonEmptyString]] = None,
    userDefinedFields: Option[Map[NonEmptyString, NonEmptyString]] = None,
    workflow: Option[zio.aws.securityhub.model.WorkflowUpdate] = None,
    relatedFindings: Option[
      Iterable[zio.aws.securityhub.model.RelatedFinding]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest = {
    import BatchUpdateFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest
      .builder()
      .findingIdentifiers(findingIdentifiers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(note.map(value => value.buildAwsValue()))(_.note)
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        confidence.map(value => RatioScale.unwrap(value): Integer)
      )(_.confidence)
      .optionallyWith(
        criticality.map(value => RatioScale.unwrap(value): Integer)
      )(_.criticality)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        userDefinedFields.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userDefinedFields)
      .optionallyWith(workflow.map(value => value.buildAwsValue()))(_.workflow)
      .optionallyWith(
        relatedFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateFindingsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateFindingsRequest.wrap(buildAwsValue())
}
object BatchUpdateFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchUpdateFindingsRequest =
      zio.aws.securityhub.model.BatchUpdateFindingsRequest(
        findingIdentifiers.map { item =>
          item.asEditable
        },
        note.map(value => value.asEditable),
        severity.map(value => value.asEditable),
        verificationState.map(value => value),
        confidence.map(value => value),
        criticality.map(value => value),
        types.map(value => value),
        userDefinedFields.map(value => value),
        workflow.map(value => value.asEditable),
        relatedFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def findingIdentifiers
        : List[zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly]
    def note: Option[zio.aws.securityhub.model.NoteUpdate.ReadOnly]
    def severity: Option[zio.aws.securityhub.model.SeverityUpdate.ReadOnly]
    def verificationState: Option[zio.aws.securityhub.model.VerificationState]
    def confidence: Option[RatioScale]
    def criticality: Option[RatioScale]
    def types: Option[List[NonEmptyString]]
    def userDefinedFields: Option[Map[NonEmptyString, NonEmptyString]]
    def workflow: Option[zio.aws.securityhub.model.WorkflowUpdate.ReadOnly]
    def relatedFindings
        : Option[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]]
    def getFindingIdentifiers: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ]] = ZIO.succeed(findingIdentifiers)
    def getNote
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      AwsError.unwrapOptionField("note", note)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.SeverityUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("severity", severity)
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getConfidence: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("criticality", criticality)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
    def getUserDefinedFields
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
    def getWorkflow: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.WorkflowUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("workflow", workflow)
    def getRelatedFindings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RelatedFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindings", relatedFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest
  ) extends zio.aws.securityhub.model.BatchUpdateFindingsRequest.ReadOnly {
    override val findingIdentifiers: List[
      zio.aws.securityhub.model.AwsSecurityFindingIdentifier.ReadOnly
    ] = impl
      .findingIdentifiers()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.AwsSecurityFindingIdentifier.wrap(item)
      }
      .toList
    override val note: Option[zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      scala
        .Option(impl.note())
        .map(value => zio.aws.securityhub.model.NoteUpdate.wrap(value))
    override val severity
        : Option[zio.aws.securityhub.model.SeverityUpdate.ReadOnly] = scala
      .Option(impl.severity())
      .map(value => zio.aws.securityhub.model.SeverityUpdate.wrap(value))
    override val verificationState
        : Option[zio.aws.securityhub.model.VerificationState] = scala
      .Option(impl.verificationState())
      .map(value => zio.aws.securityhub.model.VerificationState.wrap(value))
    override val confidence: Option[RatioScale] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val criticality: Option[RatioScale] = scala
      .Option(impl.criticality())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val types: Option[List[NonEmptyString]] = scala
      .Option(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val userDefinedFields
        : Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.userDefinedFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val workflow
        : Option[zio.aws.securityhub.model.WorkflowUpdate.ReadOnly] = scala
      .Option(impl.workflow())
      .map(value => zio.aws.securityhub.model.WorkflowUpdate.wrap(value))
    override val relatedFindings
        : Option[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]] =
      scala
        .Option(impl.relatedFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.RelatedFinding.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest
  ): zio.aws.securityhub.model.BatchUpdateFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
