package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchImportFindingsResponse(
    failedCount: Integer,
    successCount: Integer,
    failedFindings: Option[
      Iterable[zio.aws.securityhub.model.ImportFindingsError]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse = {
    import BatchImportFindingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse
      .builder()
      .failedCount(failedCount: java.lang.Integer)
      .successCount(successCount: java.lang.Integer)
      .optionallyWith(
        failedFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly =
    zio.aws.securityhub.model.BatchImportFindingsResponse.wrap(buildAwsValue())
}
object BatchImportFindingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchImportFindingsResponse =
      zio.aws.securityhub.model.BatchImportFindingsResponse(
        failedCount,
        successCount,
        failedFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedCount: Integer
    def successCount: Integer
    def failedFindings
        : Option[List[zio.aws.securityhub.model.ImportFindingsError.ReadOnly]]
    def getFailedCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(failedCount)
    def getSuccessCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(successCount)
    def getFailedFindings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.ImportFindingsError.ReadOnly
    ]] = AwsError.unwrapOptionField("failedFindings", failedFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse
  ) extends zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly {
    override val failedCount: Integer = impl.failedCount(): Integer
    override val successCount: Integer = impl.successCount(): Integer
    override val failedFindings
        : Option[List[zio.aws.securityhub.model.ImportFindingsError.ReadOnly]] =
      scala
        .Option(impl.failedFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.ImportFindingsError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse
  ): zio.aws.securityhub.model.BatchImportFindingsResponse.ReadOnly =
    new Wrapper(impl)
}
