package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsSnsTopicSubscription(
    endpoint: Option[NonEmptyString] = None,
    protocol: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription = {
    import AwsSnsTopicSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription
      .builder()
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly =
    zio.aws.securityhub.model.AwsSnsTopicSubscription.wrap(buildAwsValue())
}
object AwsSnsTopicSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSnsTopicSubscription =
      zio.aws.securityhub.model.AwsSnsTopicSubscription(
        endpoint.map(value => value),
        protocol.map(value => value)
      )
    def endpoint: Option[NonEmptyString]
    def protocol: Option[NonEmptyString]
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription
  ) extends zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly {
    override val endpoint: Option[NonEmptyString] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSnsTopicSubscription
  ): zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly = new Wrapper(
    impl
  )
}
