package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsSecurityFindingFilters(
    productArn: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    awsAccountId: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    id: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    generatorId: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    region: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    `type`: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    firstObservedAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] =
      None,
    lastObservedAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] =
      None,
    createdAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] = None,
    updatedAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] = None,
    severityProduct: Option[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      None,
    severityNormalized: Option[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = None,
    severityLabel: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    confidence: Option[Iterable[zio.aws.securityhub.model.NumberFilter]] = None,
    criticality: Option[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      None,
    title: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    description: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    recommendationText: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    sourceUrl: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    productFields: Option[Iterable[zio.aws.securityhub.model.MapFilter]] = None,
    productName: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    companyName: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    userDefinedFields: Option[Iterable[zio.aws.securityhub.model.MapFilter]] =
      None,
    malwareName: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    malwareType: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    malwarePath: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    malwareState: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    networkDirection: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    networkProtocol: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    networkSourceIpV4: Option[Iterable[zio.aws.securityhub.model.IpFilter]] =
      None,
    networkSourceIpV6: Option[Iterable[zio.aws.securityhub.model.IpFilter]] =
      None,
    networkSourcePort: Option[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = None,
    networkSourceDomain: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    networkSourceMac: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    networkDestinationIpV4: Option[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = None,
    networkDestinationIpV6: Option[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = None,
    networkDestinationPort: Option[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = None,
    networkDestinationDomain: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    processName: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    processPath: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    processPid: Option[Iterable[zio.aws.securityhub.model.NumberFilter]] = None,
    processParentPid: Option[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      None,
    processLaunchedAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] =
      None,
    processTerminatedAt: Option[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = None,
    threatIntelIndicatorType: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    threatIntelIndicatorValue: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    threatIntelIndicatorCategory: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    threatIntelIndicatorLastObservedAt: Option[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = None,
    threatIntelIndicatorSource: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    threatIntelIndicatorSourceUrl: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceType: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    resourceId: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    resourcePartition: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceRegion: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    resourceTags: Option[Iterable[zio.aws.securityhub.model.MapFilter]] = None,
    resourceAwsEc2InstanceType: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceImageId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceIpV4Addresses: Option[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = None,
    resourceAwsEc2InstanceIpV6Addresses: Option[
      Iterable[zio.aws.securityhub.model.IpFilter]
    ] = None,
    resourceAwsEc2InstanceKeyName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceIamInstanceProfileArn: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceVpcId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceSubnetId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsEc2InstanceLaunchedAt: Option[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = None,
    resourceAwsS3BucketOwnerId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsS3BucketOwnerName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsIamAccessKeyUserName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsIamAccessKeyPrincipalName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsIamAccessKeyStatus: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceAwsIamAccessKeyCreatedAt: Option[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = None,
    resourceAwsIamUserUserName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceContainerName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceContainerImageId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceContainerImageName: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    resourceContainerLaunchedAt: Option[
      Iterable[zio.aws.securityhub.model.DateFilter]
    ] = None,
    resourceDetailsOther: Option[
      Iterable[zio.aws.securityhub.model.MapFilter]
    ] = None,
    complianceStatus: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    verificationState: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    workflowState: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    workflowStatus: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    recordState: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    relatedFindingsProductArn: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    relatedFindingsId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    noteText: Option[Iterable[zio.aws.securityhub.model.StringFilter]] = None,
    noteUpdatedAt: Option[Iterable[zio.aws.securityhub.model.DateFilter]] =
      None,
    noteUpdatedBy: Option[Iterable[zio.aws.securityhub.model.StringFilter]] =
      None,
    keyword: Option[Iterable[zio.aws.securityhub.model.KeywordFilter]] = None,
    findingProviderFieldsConfidence: Option[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = None,
    findingProviderFieldsCriticality: Option[
      Iterable[zio.aws.securityhub.model.NumberFilter]
    ] = None,
    findingProviderFieldsRelatedFindingsId: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    findingProviderFieldsRelatedFindingsProductArn: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    findingProviderFieldsSeverityLabel: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    findingProviderFieldsSeverityOriginal: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    findingProviderFieldsTypes: Option[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = None,
    sample: Option[Iterable[zio.aws.securityhub.model.BooleanFilter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters = {
    import AwsSecurityFindingFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
      .builder()
      .optionallyWith(
        productArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productArn)
      .optionallyWith(
        awsAccountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccountId)
      .optionallyWith(
        id.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.id)
      .optionallyWith(
        generatorId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatorId)
      .optionallyWith(
        region.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.region)
      .optionallyWith(
        `type`.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.`type`)
      .optionallyWith(
        firstObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firstObservedAt)
      .optionallyWith(
        lastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastObservedAt)
      .optionallyWith(
        createdAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdAt)
      .optionallyWith(
        updatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updatedAt)
      .optionallyWith(
        severityProduct.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityProduct)
      .optionallyWith(
        severityNormalized.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityNormalized)
      .optionallyWith(
        severityLabel.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLabel)
      .optionallyWith(
        confidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.confidence)
      .optionallyWith(
        criticality.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.criticality)
      .optionallyWith(
        title.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.title)
      .optionallyWith(
        description.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.description)
      .optionallyWith(
        recommendationText.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendationText)
      .optionallyWith(
        sourceUrl.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceUrl)
      .optionallyWith(
        productFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productFields)
      .optionallyWith(
        productName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productName)
      .optionallyWith(
        companyName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.companyName)
      .optionallyWith(
        userDefinedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userDefinedFields)
      .optionallyWith(
        malwareName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareName)
      .optionallyWith(
        malwareType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareType)
      .optionallyWith(
        malwarePath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwarePath)
      .optionallyWith(
        malwareState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.malwareState)
      .optionallyWith(
        networkDirection.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDirection)
      .optionallyWith(
        networkProtocol.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkProtocol)
      .optionallyWith(
        networkSourceIpV4.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceIpV4)
      .optionallyWith(
        networkSourceIpV6.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceIpV6)
      .optionallyWith(
        networkSourcePort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourcePort)
      .optionallyWith(
        networkSourceDomain.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceDomain)
      .optionallyWith(
        networkSourceMac.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSourceMac)
      .optionallyWith(
        networkDestinationIpV4.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationIpV4)
      .optionallyWith(
        networkDestinationIpV6.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationIpV6)
      .optionallyWith(
        networkDestinationPort.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationPort)
      .optionallyWith(
        networkDestinationDomain.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkDestinationDomain)
      .optionallyWith(
        processName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processName)
      .optionallyWith(
        processPath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processPath)
      .optionallyWith(
        processPid.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processPid)
      .optionallyWith(
        processParentPid.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processParentPid)
      .optionallyWith(
        processLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processLaunchedAt)
      .optionallyWith(
        processTerminatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processTerminatedAt)
      .optionallyWith(
        threatIntelIndicatorType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorType)
      .optionallyWith(
        threatIntelIndicatorValue.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorValue)
      .optionallyWith(
        threatIntelIndicatorCategory.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorCategory)
      .optionallyWith(
        threatIntelIndicatorLastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorLastObservedAt)
      .optionallyWith(
        threatIntelIndicatorSource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorSource)
      .optionallyWith(
        threatIntelIndicatorSourceUrl.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatIntelIndicatorSourceUrl)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourcePartition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcePartition)
      .optionallyWith(
        resourceRegion.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRegion)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceAwsEc2InstanceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceType)
      .optionallyWith(
        resourceAwsEc2InstanceImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceImageId)
      .optionallyWith(
        resourceAwsEc2InstanceIpV4Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIpV4Addresses)
      .optionallyWith(
        resourceAwsEc2InstanceIpV6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIpV6Addresses)
      .optionallyWith(
        resourceAwsEc2InstanceKeyName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceKeyName)
      .optionallyWith(
        resourceAwsEc2InstanceIamInstanceProfileArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceIamInstanceProfileArn)
      .optionallyWith(
        resourceAwsEc2InstanceVpcId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceVpcId)
      .optionallyWith(
        resourceAwsEc2InstanceSubnetId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceSubnetId)
      .optionallyWith(
        resourceAwsEc2InstanceLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsEc2InstanceLaunchedAt)
      .optionallyWith(
        resourceAwsS3BucketOwnerId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsS3BucketOwnerId)
      .optionallyWith(
        resourceAwsS3BucketOwnerName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsS3BucketOwnerName)
      .optionallyWith(
        resourceAwsIamAccessKeyUserName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyUserName)
      .optionallyWith(
        resourceAwsIamAccessKeyPrincipalName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyPrincipalName)
      .optionallyWith(
        resourceAwsIamAccessKeyStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyStatus)
      .optionallyWith(
        resourceAwsIamAccessKeyCreatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamAccessKeyCreatedAt)
      .optionallyWith(
        resourceAwsIamUserUserName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceAwsIamUserUserName)
      .optionallyWith(
        resourceContainerName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerName)
      .optionallyWith(
        resourceContainerImageId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerImageId)
      .optionallyWith(
        resourceContainerImageName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerImageName)
      .optionallyWith(
        resourceContainerLaunchedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceContainerLaunchedAt)
      .optionallyWith(
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDetailsOther)
      .optionallyWith(
        complianceStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceStatus)
      .optionallyWith(
        verificationState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verificationState)
      .optionallyWith(
        workflowState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowState)
      .optionallyWith(
        workflowStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowStatus)
      .optionallyWith(
        recordState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordState)
      .optionallyWith(
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsProductArn)
      .optionallyWith(
        relatedFindingsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsId)
      .optionallyWith(
        noteText.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteText)
      .optionallyWith(
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedAt)
      .optionallyWith(
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedBy)
      .optionallyWith(
        keyword.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyword)
      .optionallyWith(
        findingProviderFieldsConfidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsConfidence)
      .optionallyWith(
        findingProviderFieldsCriticality.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsCriticality)
      .optionallyWith(
        findingProviderFieldsRelatedFindingsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsRelatedFindingsId)
      .optionallyWith(
        findingProviderFieldsRelatedFindingsProductArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsRelatedFindingsProductArn)
      .optionallyWith(
        findingProviderFieldsSeverityLabel.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsSeverityLabel)
      .optionallyWith(
        findingProviderFieldsSeverityOriginal.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsSeverityOriginal)
      .optionallyWith(
        findingProviderFieldsTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingProviderFieldsTypes)
      .optionallyWith(
        sample.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sample)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly =
    zio.aws.securityhub.model.AwsSecurityFindingFilters.wrap(buildAwsValue())
}
object AwsSecurityFindingFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecurityFindingFilters =
      zio.aws.securityhub.model.AwsSecurityFindingFilters(
        productArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        awsAccountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        generatorId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        region.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityProduct.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityNormalized.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityLabel.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        confidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        criticality.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        title.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationText.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceUrl.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        companyName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userDefinedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwarePath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        malwareState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDirection.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkProtocol.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceIpV4.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceIpV6.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourcePort.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceDomain.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkSourceMac.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationIpV4.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationIpV6.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationPort.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkDestinationDomain.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processPath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processPid.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processParentPid.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        processTerminatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorValue.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorCategory.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorLastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorSource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        threatIntelIndicatorSourceUrl.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourcePartition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRegion.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIpV4Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIpV6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceKeyName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceIamInstanceProfileArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceVpcId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceSubnetId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsEc2InstanceLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsS3BucketOwnerId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsS3BucketOwnerName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyUserName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyPrincipalName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamAccessKeyCreatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceAwsIamUserUserName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerImageId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerImageName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceContainerLaunchedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        verificationState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recordState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteText.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        keyword.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsConfidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsCriticality.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsRelatedFindingsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsRelatedFindingsProductArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsSeverityLabel.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsSeverityOriginal.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        findingProviderFieldsTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sample.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def awsAccountId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def id: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def generatorId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def region: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def `type`: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def firstObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def lastObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def createdAt: Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def updatedAt: Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def severityProduct
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def severityNormalized
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def severityLabel
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def confidence
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def criticality
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def title: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def description
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def recommendationText
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def sourceUrl: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def productFields
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def productName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def companyName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def userDefinedFields
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def malwareName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwareType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwarePath
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def malwareState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkDirection
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkProtocol
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkSourceIpV4
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkSourceIpV6
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkSourcePort
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def networkSourceDomain
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkSourceMac
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def networkDestinationIpV4
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkDestinationIpV6
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def networkDestinationPort
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def networkDestinationDomain
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processPath
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def processPid
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def processParentPid
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def processLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def processTerminatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def threatIntelIndicatorType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorValue
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorCategory
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorLastObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def threatIntelIndicatorSource
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def threatIntelIndicatorSourceUrl
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourcePartition
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceRegion
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceTags: Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def resourceAwsEc2InstanceType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceImageId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceIpV4Addresses
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def resourceAwsEc2InstanceIpV6Addresses
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]]
    def resourceAwsEc2InstanceKeyName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceIamInstanceProfileArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceVpcId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceSubnetId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsEc2InstanceLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceAwsS3BucketOwnerId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsS3BucketOwnerName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyUserName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyPrincipalName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceAwsIamAccessKeyCreatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceAwsIamUserUserName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerImageId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerImageName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceContainerLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def resourceDetailsOther
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def complianceStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def verificationState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def workflowState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def workflowStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def recordState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsProductArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteText: Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteUpdatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def noteUpdatedBy
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def keyword: Option[List[zio.aws.securityhub.model.KeywordFilter.ReadOnly]]
    def findingProviderFieldsConfidence
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def findingProviderFieldsCriticality
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def findingProviderFieldsRelatedFindingsId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsRelatedFindingsProductArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsSeverityLabel
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsSeverityOriginal
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def findingProviderFieldsTypes
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def sample: Option[List[zio.aws.securityhub.model.BooleanFilter.ReadOnly]]
    def getProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productArn", productArn)
    def getAwsAccountId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("id", id)
    def getGeneratorId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("generatorId", generatorId)
    def getRegion: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("region", region)
    def getType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("type", `type`)
    def getFirstObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getCreatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getSeverityProduct: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityProduct", severityProduct)
    def getSeverityNormalized: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityNormalized", severityNormalized)
    def getSeverityLabel: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLabel", severityLabel)
    def getConfidence: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("criticality", criticality)
    def getTitle: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("description", description)
    def getRecommendationText: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendationText", recommendationText)
    def getSourceUrl: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getProductFields: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productFields", productFields)
    def getProductName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productName", productName)
    def getCompanyName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("companyName", companyName)
    def getUserDefinedFields: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
    def getMalwareName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareName", malwareName)
    def getMalwareType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareType", malwareType)
    def getMalwarePath: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwarePath", malwarePath)
    def getMalwareState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("malwareState", malwareState)
    def getNetworkDirection: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkDirection", networkDirection)
    def getNetworkProtocol: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkProtocol", networkProtocol)
    def getNetworkSourceIpV4: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceIpV4", networkSourceIpV4)
    def getNetworkSourceIpV6: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceIpV6", networkSourceIpV6)
    def getNetworkSourcePort: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourcePort", networkSourcePort)
    def getNetworkSourceDomain: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceDomain", networkSourceDomain)
    def getNetworkSourceMac: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSourceMac", networkSourceMac)
    def getNetworkDestinationIpV4: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationIpV4",
      networkDestinationIpV4
    )
    def getNetworkDestinationIpV6: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationIpV6",
      networkDestinationIpV6
    )
    def getNetworkDestinationPort: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationPort",
      networkDestinationPort
    )
    def getNetworkDestinationDomain: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "networkDestinationDomain",
      networkDestinationDomain
    )
    def getProcessName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processName", processName)
    def getProcessPath: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processPath", processPath)
    def getProcessPid: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processPid", processPid)
    def getProcessParentPid: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processParentPid", processParentPid)
    def getProcessLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processLaunchedAt", processLaunchedAt)
    def getProcessTerminatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("processTerminatedAt", processTerminatedAt)
    def getThreatIntelIndicatorType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorType",
      threatIntelIndicatorType
    )
    def getThreatIntelIndicatorValue: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorValue",
      threatIntelIndicatorValue
    )
    def getThreatIntelIndicatorCategory: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorCategory",
      threatIntelIndicatorCategory
    )
    def getThreatIntelIndicatorLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorLastObservedAt",
      threatIntelIndicatorLastObservedAt
    )
    def getThreatIntelIndicatorSource: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorSource",
      threatIntelIndicatorSource
    )
    def getThreatIntelIndicatorSourceUrl: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "threatIntelIndicatorSourceUrl",
      threatIntelIndicatorSourceUrl
    )
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourcePartition: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcePartition", resourcePartition)
    def getResourceRegion: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceAwsEc2InstanceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceType",
      resourceAwsEc2InstanceType
    )
    def getResourceAwsEc2InstanceImageId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceImageId",
      resourceAwsEc2InstanceImageId
    )
    def getResourceAwsEc2InstanceIpV4Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIpV4Addresses",
      resourceAwsEc2InstanceIpV4Addresses
    )
    def getResourceAwsEc2InstanceIpV6Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.IpFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIpV6Addresses",
      resourceAwsEc2InstanceIpV6Addresses
    )
    def getResourceAwsEc2InstanceKeyName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceKeyName",
      resourceAwsEc2InstanceKeyName
    )
    def getResourceAwsEc2InstanceIamInstanceProfileArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceIamInstanceProfileArn",
      resourceAwsEc2InstanceIamInstanceProfileArn
    )
    def getResourceAwsEc2InstanceVpcId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceVpcId",
      resourceAwsEc2InstanceVpcId
    )
    def getResourceAwsEc2InstanceSubnetId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceSubnetId",
      resourceAwsEc2InstanceSubnetId
    )
    def getResourceAwsEc2InstanceLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsEc2InstanceLaunchedAt",
      resourceAwsEc2InstanceLaunchedAt
    )
    def getResourceAwsS3BucketOwnerId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsS3BucketOwnerId",
      resourceAwsS3BucketOwnerId
    )
    def getResourceAwsS3BucketOwnerName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsS3BucketOwnerName",
      resourceAwsS3BucketOwnerName
    )
    def getResourceAwsIamAccessKeyUserName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyUserName",
      resourceAwsIamAccessKeyUserName
    )
    def getResourceAwsIamAccessKeyPrincipalName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyPrincipalName",
      resourceAwsIamAccessKeyPrincipalName
    )
    def getResourceAwsIamAccessKeyStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyStatus",
      resourceAwsIamAccessKeyStatus
    )
    def getResourceAwsIamAccessKeyCreatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamAccessKeyCreatedAt",
      resourceAwsIamAccessKeyCreatedAt
    )
    def getResourceAwsIamUserUserName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceAwsIamUserUserName",
      resourceAwsIamUserUserName
    )
    def getResourceContainerName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceContainerName", resourceContainerName)
    def getResourceContainerImageId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerImageId",
      resourceContainerImageId
    )
    def getResourceContainerImageName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerImageName",
      resourceContainerImageName
    )
    def getResourceContainerLaunchedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceContainerLaunchedAt",
      resourceContainerLaunchedAt
    )
    def getResourceDetailsOther: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceDetailsOther", resourceDetailsOther)
    def getComplianceStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getVerificationState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("verificationState", verificationState)
    def getWorkflowState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowState", workflowState)
    def getWorkflowStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowStatus", workflowStatus)
    def getRecordState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("recordState", recordState)
    def getRelatedFindingsProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relatedFindingsProductArn",
      relatedFindingsProductArn
    )
    def getRelatedFindingsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindingsId", relatedFindingsId)
    def getNoteText: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteText", noteText)
    def getNoteUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedAt", noteUpdatedAt)
    def getNoteUpdatedBy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedBy", noteUpdatedBy)
    def getKeyword: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.KeywordFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("keyword", keyword)
    def getFindingProviderFieldsConfidence: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsConfidence",
      findingProviderFieldsConfidence
    )
    def getFindingProviderFieldsCriticality: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsCriticality",
      findingProviderFieldsCriticality
    )
    def getFindingProviderFieldsRelatedFindingsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsRelatedFindingsId",
      findingProviderFieldsRelatedFindingsId
    )
    def getFindingProviderFieldsRelatedFindingsProductArn
        : ZIO[Any, AwsError, List[
          zio.aws.securityhub.model.StringFilter.ReadOnly
        ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsRelatedFindingsProductArn",
      findingProviderFieldsRelatedFindingsProductArn
    )
    def getFindingProviderFieldsSeverityLabel: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsSeverityLabel",
      findingProviderFieldsSeverityLabel
    )
    def getFindingProviderFieldsSeverityOriginal: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsSeverityOriginal",
      findingProviderFieldsSeverityOriginal
    )
    def getFindingProviderFieldsTypes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "findingProviderFieldsTypes",
      findingProviderFieldsTypes
    )
    def getSample: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.BooleanFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("sample", sample)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ) extends zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly {
    override val productArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.productArn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val awsAccountId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.awsAccountId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val id
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.id())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val generatorId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.generatorId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val region
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.region())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val `type`
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.`type`())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val firstObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.firstObservedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val lastObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.lastObservedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val createdAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.createdAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val updatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.updatedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val severityProduct
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.severityProduct())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val severityNormalized
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.severityNormalized())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val severityLabel
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.severityLabel())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val confidence
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.confidence())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val criticality
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.criticality())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val title
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.title())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val description
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.description())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val recommendationText
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.recommendationText())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val sourceUrl
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.sourceUrl())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val productFields
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] = scala
      .Option(impl.productFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.MapFilter.wrap(item)
        }.toList
      )
    override val productName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.productName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val companyName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.companyName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val userDefinedFields
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] = scala
      .Option(impl.userDefinedFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.MapFilter.wrap(item)
        }.toList
      )
    override val malwareName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.malwareName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val malwareType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.malwareType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val malwarePath
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.malwarePath())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val malwareState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.malwareState())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val networkDirection
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkDirection())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val networkProtocol
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkProtocol())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val networkSourceIpV4
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.networkSourceIpV4())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val networkSourceIpV6
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.networkSourceIpV6())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val networkSourcePort
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.networkSourcePort())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val networkSourceDomain
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkSourceDomain())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val networkSourceMac
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkSourceMac())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val networkDestinationIpV4
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.networkDestinationIpV4())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val networkDestinationIpV6
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.networkDestinationIpV6())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val networkDestinationPort
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.networkDestinationPort())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val networkDestinationDomain
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.networkDestinationDomain())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val processName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.processName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val processPath
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.processPath())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val processPid
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.processPid())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val processParentPid
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.processParentPid())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val processLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.processLaunchedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val processTerminatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.processTerminatedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorValue
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorValue())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorCategory
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorCategory())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorLastObservedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorLastObservedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorSource
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorSource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val threatIntelIndicatorSourceUrl
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.threatIntelIndicatorSourceUrl())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourcePartition
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourcePartition())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceRegion
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceRegion())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceTags
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.MapFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceType
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceType())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceImageId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceImageId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceIpV4Addresses
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceIpV4Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceIpV6Addresses
        : Option[List[zio.aws.securityhub.model.IpFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceIpV6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.IpFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceKeyName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceKeyName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceIamInstanceProfileArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceIamInstanceProfileArn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceVpcId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceVpcId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceSubnetId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceSubnetId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsEc2InstanceLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsEc2InstanceLaunchedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val resourceAwsS3BucketOwnerId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsS3BucketOwnerId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsS3BucketOwnerName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsS3BucketOwnerName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsIamAccessKeyUserName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsIamAccessKeyUserName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsIamAccessKeyPrincipalName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsIamAccessKeyPrincipalName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsIamAccessKeyStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsIamAccessKeyStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceAwsIamAccessKeyCreatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsIamAccessKeyCreatedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val resourceAwsIamUserUserName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceAwsIamUserUserName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceContainerName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceContainerName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceContainerImageId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceContainerImageId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceContainerImageName
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.resourceContainerImageName())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val resourceContainerLaunchedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.resourceContainerLaunchedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val resourceDetailsOther
        : Option[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] = scala
      .Option(impl.resourceDetailsOther())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.MapFilter.wrap(item)
        }.toList
      )
    override val complianceStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.complianceStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val verificationState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.verificationState())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val workflowState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.workflowState())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val workflowStatus
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.workflowStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val recordState
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.recordState())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val relatedFindingsProductArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.relatedFindingsProductArn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val relatedFindingsId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.relatedFindingsId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val noteText
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.noteText())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val noteUpdatedAt
        : Option[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] = scala
      .Option(impl.noteUpdatedAt())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.DateFilter.wrap(item)
        }.toList
      )
    override val noteUpdatedBy
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.noteUpdatedBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val keyword
        : Option[List[zio.aws.securityhub.model.KeywordFilter.ReadOnly]] = scala
      .Option(impl.keyword())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.KeywordFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsConfidence
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsConfidence())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsCriticality
        : Option[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsCriticality())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.NumberFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsRelatedFindingsId
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsRelatedFindingsId())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsRelatedFindingsProductArn
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsRelatedFindingsProductArn())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsSeverityLabel
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsSeverityLabel())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsSeverityOriginal
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsSeverityOriginal())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val findingProviderFieldsTypes
        : Option[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] = scala
      .Option(impl.findingProviderFieldsTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.StringFilter.wrap(item)
        }.toList
      )
    override val sample
        : Option[List[zio.aws.securityhub.model.BooleanFilter.ReadOnly]] = scala
      .Option(impl.sample())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.BooleanFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters
  ): zio.aws.securityhub.model.AwsSecurityFindingFilters.ReadOnly = new Wrapper(
    impl
  )
}
