package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsSecretsManagerSecretDetails(
    rotationRules: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules
    ] = None,
    rotationOccurredWithinFrequency: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    rotationEnabled: Option[Boolean] = None,
    rotationLambdaArn: Option[NonEmptyString] = None,
    deleted: Option[Boolean] = None,
    name: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails = {
    import AwsSecretsManagerSecretDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
      .builder()
      .optionallyWith(rotationRules.map(value => value.buildAwsValue()))(
        _.rotationRules
      )
      .optionallyWith(
        rotationOccurredWithinFrequency.map(value => value: java.lang.Boolean)
      )(_.rotationOccurredWithinFrequency)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(rotationEnabled.map(value => value: java.lang.Boolean))(
        _.rotationEnabled
      )
      .optionallyWith(
        rotationLambdaArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rotationLambdaArn)
      .optionallyWith(deleted.map(value => value: java.lang.Boolean))(_.deleted)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSecretsManagerSecretDetails
      .wrap(buildAwsValue())
}
object AwsSecretsManagerSecretDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSecretsManagerSecretDetails =
      zio.aws.securityhub.model.AwsSecretsManagerSecretDetails(
        rotationRules.map(value => value.asEditable),
        rotationOccurredWithinFrequency.map(value => value),
        kmsKeyId.map(value => value),
        rotationEnabled.map(value => value),
        rotationLambdaArn.map(value => value),
        deleted.map(value => value),
        name.map(value => value),
        description.map(value => value)
      )
    def rotationRules: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ]
    def rotationOccurredWithinFrequency: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def rotationEnabled: Option[Boolean]
    def rotationLambdaArn: Option[NonEmptyString]
    def deleted: Option[Boolean]
    def name: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def getRotationRules: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ] = AwsError.unwrapOptionField("rotationRules", rotationRules)
    def getRotationOccurredWithinFrequency: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "rotationOccurredWithinFrequency",
        rotationOccurredWithinFrequency
      )
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getRotationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("rotationEnabled", rotationEnabled)
    def getRotationLambdaArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rotationLambdaArn", rotationLambdaArn)
    def getDeleted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ) extends zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly {
    override val rotationRules: Option[
      zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules.ReadOnly
    ] = scala
      .Option(impl.rotationRules())
      .map(value =>
        zio.aws.securityhub.model.AwsSecretsManagerSecretRotationRules
          .wrap(value)
      )
    override val rotationOccurredWithinFrequency: Option[Boolean] = scala
      .Option(impl.rotationOccurredWithinFrequency())
      .map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rotationEnabled: Option[Boolean] =
      scala.Option(impl.rotationEnabled()).map(value => value: Boolean)
    override val rotationLambdaArn: Option[NonEmptyString] = scala
      .Option(impl.rotationLambdaArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deleted: Option[Boolean] =
      scala.Option(impl.deleted()).map(value => value: Boolean)
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSecretsManagerSecretDetails
  ): zio.aws.securityhub.model.AwsSecretsManagerSecretDetails.ReadOnly =
    new Wrapper(impl)
}
