package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsS3BucketDetails(
    ownerId: Option[NonEmptyString] = None,
    ownerName: Option[NonEmptyString] = None,
    ownerAccountId: Option[NonEmptyString] = None,
    createdAt: Option[NonEmptyString] = None,
    serverSideEncryptionConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
    ] = None,
    bucketLifecycleConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
    ] = None,
    publicAccessBlockConfiguration: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
    ] = None,
    accessControlList: Option[NonEmptyString] = None,
    bucketLoggingConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration
    ] = None,
    bucketWebsiteConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration
    ] = None,
    bucketNotificationConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration
    ] = None,
    bucketVersioningConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails = {
    import AwsS3BucketDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
      .builder()
      .optionallyWith(
        ownerId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        ownerName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ownerName)
      .optionallyWith(
        ownerAccountId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(
        bucketLifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.bucketLifecycleConfiguration)
      .optionallyWith(
        publicAccessBlockConfiguration.map(value => value.buildAwsValue())
      )(_.publicAccessBlockConfiguration)
      .optionallyWith(
        accessControlList.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessControlList)
      .optionallyWith(
        bucketLoggingConfiguration.map(value => value.buildAwsValue())
      )(_.bucketLoggingConfiguration)
      .optionallyWith(
        bucketWebsiteConfiguration.map(value => value.buildAwsValue())
      )(_.bucketWebsiteConfiguration)
      .optionallyWith(
        bucketNotificationConfiguration.map(value => value.buildAwsValue())
      )(_.bucketNotificationConfiguration)
      .optionallyWith(
        bucketVersioningConfiguration.map(value => value.buildAwsValue())
      )(_.bucketVersioningConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketDetails.wrap(buildAwsValue())
}
object AwsS3BucketDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsS3BucketDetails =
      zio.aws.securityhub.model.AwsS3BucketDetails(
        ownerId.map(value => value),
        ownerName.map(value => value),
        ownerAccountId.map(value => value),
        createdAt.map(value => value),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        bucketLifecycleConfiguration.map(value => value.asEditable),
        publicAccessBlockConfiguration.map(value => value.asEditable),
        accessControlList.map(value => value),
        bucketLoggingConfiguration.map(value => value.asEditable),
        bucketWebsiteConfiguration.map(value => value.asEditable),
        bucketNotificationConfiguration.map(value => value.asEditable),
        bucketVersioningConfiguration.map(value => value.asEditable)
      )
    def ownerId: Option[NonEmptyString]
    def ownerName: Option[NonEmptyString]
    def ownerAccountId: Option[NonEmptyString]
    def createdAt: Option[NonEmptyString]
    def serverSideEncryptionConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ]
    def bucketLifecycleConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ]
    def publicAccessBlockConfiguration: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ]
    def accessControlList: Option[NonEmptyString]
    def bucketLoggingConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ]
    def bucketWebsiteConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ]
    def bucketNotificationConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ]
    def bucketVersioningConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ]
    def getOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getOwnerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerName", ownerName)
    def getOwnerAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getBucketLifecycleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLifecycleConfiguration",
      bucketLifecycleConfiguration
    )
    def getPublicAccessBlockConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "publicAccessBlockConfiguration",
      publicAccessBlockConfiguration
    )
    def getAccessControlList: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getBucketLoggingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketLoggingConfiguration",
      bucketLoggingConfiguration
    )
    def getBucketWebsiteConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketWebsiteConfiguration",
      bucketWebsiteConfiguration
    )
    def getBucketNotificationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketNotificationConfiguration",
      bucketNotificationConfiguration
    )
    def getBucketVersioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketVersioningConfiguration",
      bucketVersioningConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly {
    override val ownerId: Option[NonEmptyString] = scala
      .Option(impl.ownerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerName: Option[NonEmptyString] = scala
      .Option(impl.ownerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ownerAccountId: Option[NonEmptyString] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdAt: Option[NonEmptyString] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serverSideEncryptionConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketServerSideEncryptionConfiguration
          .wrap(value)
      )
    override val bucketLifecycleConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.bucketLifecycleConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
          .wrap(value)
      )
    override val publicAccessBlockConfiguration: Option[
      zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails.ReadOnly
    ] = scala
      .Option(impl.publicAccessBlockConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3AccountPublicAccessBlockDetails
          .wrap(value)
      )
    override val accessControlList: Option[NonEmptyString] = scala
      .Option(impl.accessControlList())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val bucketLoggingConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.ReadOnly
    ] = scala
      .Option(impl.bucketLoggingConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketLoggingConfiguration.wrap(value)
      )
    override val bucketWebsiteConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.ReadOnly
    ] = scala
      .Option(impl.bucketWebsiteConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketWebsiteConfiguration.wrap(value)
      )
    override val bucketNotificationConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration.ReadOnly
    ] = scala
      .Option(impl.bucketNotificationConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketNotificationConfiguration
          .wrap(value)
      )
    override val bucketVersioningConfiguration: Option[
      zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration.ReadOnly
    ] = scala
      .Option(impl.bucketVersioningConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketBucketVersioningConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketDetails
  ): zio.aws.securityhub.model.AwsS3BucketDetails.ReadOnly = new Wrapper(impl)
}
