package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterIamRole(
    applyStatus: Option[NonEmptyString] = None,
    iamRoleArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole = {
    import AwsRedshiftClusterIamRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole
      .builder()
      .optionallyWith(
        applyStatus.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.applyStatus)
      .optionallyWith(
        iamRoleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterIamRole.wrap(buildAwsValue())
}
object AwsRedshiftClusterIamRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterIamRole =
      zio.aws.securityhub.model.AwsRedshiftClusterIamRole(
        applyStatus.map(value => value),
        iamRoleArn.map(value => value)
      )
    def applyStatus: Option[NonEmptyString]
    def iamRoleArn: Option[NonEmptyString]
    def getApplyStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("applyStatus", applyStatus)
    def getIamRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly {
    override val applyStatus: Option[NonEmptyString] = scala
      .Option(impl.applyStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamRoleArn: Option[NonEmptyString] = scala
      .Option(impl.iamRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterIamRole
  ): zio.aws.securityhub.model.AwsRedshiftClusterIamRole.ReadOnly = new Wrapper(
    impl
  )
}
