package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterHsmStatus(
    hsmClientCertificateIdentifier: Option[NonEmptyString] = None,
    hsmConfigurationIdentifier: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterHsmStatus = {
    import AwsRedshiftClusterHsmStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterHsmStatus
      .builder()
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.wrap(buildAwsValue())
}
object AwsRedshiftClusterHsmStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterHsmStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus =
      zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus(
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        status.map(value => value)
      )
    def hsmClientCertificateIdentifier: Option[NonEmptyString]
    def hsmConfigurationIdentifier: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterHsmStatus
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly {
    override val hsmClientCertificateIdentifier: Option[NonEmptyString] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val hsmConfigurationIdentifier: Option[NonEmptyString] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterHsmStatus
  ): zio.aws.securityhub.model.AwsRedshiftClusterHsmStatus.ReadOnly =
    new Wrapper(impl)
}
