package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbSnapshotDetails(
    dbSnapshotIdentifier: Option[NonEmptyString] = None,
    dbInstanceIdentifier: Option[NonEmptyString] = None,
    snapshotCreateTime: Option[NonEmptyString] = None,
    engine: Option[NonEmptyString] = None,
    allocatedStorage: Option[Integer] = None,
    status: Option[NonEmptyString] = None,
    port: Option[Integer] = None,
    availabilityZone: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    instanceCreateTime: Option[NonEmptyString] = None,
    masterUsername: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    licenseModel: Option[NonEmptyString] = None,
    snapshotType: Option[NonEmptyString] = None,
    iops: Option[Integer] = None,
    optionGroupName: Option[NonEmptyString] = None,
    percentProgress: Option[Integer] = None,
    sourceRegion: Option[NonEmptyString] = None,
    sourceDbSnapshotIdentifier: Option[NonEmptyString] = None,
    storageType: Option[NonEmptyString] = None,
    tdeCredentialArn: Option[NonEmptyString] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    timezone: Option[NonEmptyString] = None,
    iamDatabaseAuthenticationEnabled: Option[Boolean] = None,
    processorFeatures: Option[
      Iterable[zio.aws.securityhub.model.AwsRdsDbProcessorFeature]
    ] = None,
    dbiResourceId: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails = {
    import AwsRdsDbSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
      .builder()
      .optionallyWith(
        dbSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbSnapshotIdentifier)
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotCreateTime)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        availabilityZone.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        instanceCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceCreateTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        snapshotType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotType)
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        optionGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.optionGroupName)
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(
        sourceRegion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceRegion)
      .optionallyWith(
        sourceDbSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceDbSnapshotIdentifier)
      .optionallyWith(
        storageType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.storageType)
      .optionallyWith(
        tdeCredentialArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tdeCredentialArn)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        timezone.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.timezone)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        dbiResourceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbiResourceId)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.wrap(buildAwsValue())
}
object AwsRdsDbSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbSnapshotDetails =
      zio.aws.securityhub.model.AwsRdsDbSnapshotDetails(
        dbSnapshotIdentifier.map(value => value),
        dbInstanceIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        vpcId.map(value => value),
        instanceCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        percentProgress.map(value => value),
        sourceRegion.map(value => value),
        sourceDbSnapshotIdentifier.map(value => value),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        timezone.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbiResourceId.map(value => value)
      )
    def dbSnapshotIdentifier: Option[NonEmptyString]
    def dbInstanceIdentifier: Option[NonEmptyString]
    def snapshotCreateTime: Option[NonEmptyString]
    def engine: Option[NonEmptyString]
    def allocatedStorage: Option[Integer]
    def status: Option[NonEmptyString]
    def port: Option[Integer]
    def availabilityZone: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def instanceCreateTime: Option[NonEmptyString]
    def masterUsername: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def licenseModel: Option[NonEmptyString]
    def snapshotType: Option[NonEmptyString]
    def iops: Option[Integer]
    def optionGroupName: Option[NonEmptyString]
    def percentProgress: Option[Integer]
    def sourceRegion: Option[NonEmptyString]
    def sourceDbSnapshotIdentifier: Option[NonEmptyString]
    def storageType: Option[NonEmptyString]
    def tdeCredentialArn: Option[NonEmptyString]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def timezone: Option[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Option[Boolean]
    def processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ]
    def dbiResourceId: Option[NonEmptyString]
    def getDbSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstanceCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getIops: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getSourceRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getSourceDbSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "sourceDbSnapshotIdentifier",
        sourceDbSnapshotIdentifier
      )
    def getStorageType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTimezone: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getDbiResourceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly {
    override val dbSnapshotIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbSnapshotIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbInstanceIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotCreateTime: Option[NonEmptyString] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engine: Option[NonEmptyString] = scala
      .Option(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Option[Integer] =
      scala.Option(impl.allocatedStorage()).map(value => value: Integer)
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val availabilityZone: Option[NonEmptyString] = scala
      .Option(impl.availabilityZone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceCreateTime: Option[NonEmptyString] = scala
      .Option(impl.instanceCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Option[NonEmptyString] = scala
      .Option(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotType: Option[NonEmptyString] = scala
      .Option(impl.snapshotType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iops: Option[Integer] =
      scala.Option(impl.iops()).map(value => value: Integer)
    override val optionGroupName: Option[NonEmptyString] = scala
      .Option(impl.optionGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val percentProgress: Option[Integer] =
      scala.Option(impl.percentProgress()).map(value => value: Integer)
    override val sourceRegion: Option[NonEmptyString] = scala
      .Option(impl.sourceRegion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceDbSnapshotIdentifier: Option[NonEmptyString] = scala
      .Option(impl.sourceDbSnapshotIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val storageType: Option[NonEmptyString] = scala
      .Option(impl.storageType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val tdeCredentialArn: Option[NonEmptyString] = scala
      .Option(impl.tdeCredentialArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timezone: Option[NonEmptyString] = scala
      .Option(impl.timezone())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamDatabaseAuthenticationEnabled: Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
    override val processorFeatures: Option[
      List[zio.aws.securityhub.model.AwsRdsDbProcessorFeature.ReadOnly]
    ] = scala
      .Option(impl.processorFeatures())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsRdsDbProcessorFeature.wrap(item)
        }.toList
      )
    override val dbiResourceId: Option[NonEmptyString] = scala
      .Option(impl.dbiResourceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbSnapshotDetails
  ): zio.aws.securityhub.model.AwsRdsDbSnapshotDetails.ReadOnly = new Wrapper(
    impl
  )
}
