package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterSnapshotDetails(
    availabilityZones: Option[Iterable[NonEmptyString]] = None,
    snapshotCreateTime: Option[NonEmptyString] = None,
    engine: Option[NonEmptyString] = None,
    allocatedStorage: Option[Integer] = None,
    status: Option[NonEmptyString] = None,
    port: Option[Integer] = None,
    vpcId: Option[NonEmptyString] = None,
    clusterCreateTime: Option[NonEmptyString] = None,
    masterUsername: Option[NonEmptyString] = None,
    engineVersion: Option[NonEmptyString] = None,
    licenseModel: Option[NonEmptyString] = None,
    snapshotType: Option[NonEmptyString] = None,
    percentProgress: Option[Integer] = None,
    storageEncrypted: Option[Boolean] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    dbClusterIdentifier: Option[NonEmptyString] = None,
    dbClusterSnapshotIdentifier: Option[NonEmptyString] = None,
    iamDatabaseAuthenticationEnabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails = {
    import AwsRdsDbClusterSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        snapshotCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotCreateTime)
      .optionallyWith(
        engine.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.engine)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        clusterCreateTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterCreateTime)
      .optionallyWith(
        masterUsername.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.masterUsername)
      .optionallyWith(
        engineVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.engineVersion)
      .optionallyWith(
        licenseModel.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.licenseModel)
      .optionallyWith(
        snapshotType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.snapshotType)
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        dbClusterIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails
      .wrap(buildAwsValue())
}
object AwsRdsDbClusterSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails =
      zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails(
        availabilityZones.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        percentProgress.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value)
      )
    def availabilityZones: Option[List[NonEmptyString]]
    def snapshotCreateTime: Option[NonEmptyString]
    def engine: Option[NonEmptyString]
    def allocatedStorage: Option[Integer]
    def status: Option[NonEmptyString]
    def port: Option[Integer]
    def vpcId: Option[NonEmptyString]
    def clusterCreateTime: Option[NonEmptyString]
    def masterUsername: Option[NonEmptyString]
    def engineVersion: Option[NonEmptyString]
    def licenseModel: Option[NonEmptyString]
    def snapshotType: Option[NonEmptyString]
    def percentProgress: Option[Integer]
    def storageEncrypted: Option[Boolean]
    def kmsKeyId: Option[NonEmptyString]
    def dbClusterIdentifier: Option[NonEmptyString]
    def dbClusterSnapshotIdentifier: Option[NonEmptyString]
    def iamDatabaseAuthenticationEnabled: Option[Boolean]
    def getAvailabilityZones: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSnapshotCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engine", engine)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClusterCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly {
    override val availabilityZones: Option[List[NonEmptyString]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val snapshotCreateTime: Option[NonEmptyString] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engine: Option[NonEmptyString] = scala
      .Option(impl.engine())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val allocatedStorage: Option[Integer] =
      scala.Option(impl.allocatedStorage()).map(value => value: Integer)
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterCreateTime: Option[NonEmptyString] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val masterUsername: Option[NonEmptyString] = scala
      .Option(impl.masterUsername())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val engineVersion: Option[NonEmptyString] = scala
      .Option(impl.engineVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val licenseModel: Option[NonEmptyString] = scala
      .Option(impl.licenseModel())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val snapshotType: Option[NonEmptyString] = scala
      .Option(impl.snapshotType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val percentProgress: Option[Integer] =
      scala.Option(impl.percentProgress()).map(value => value: Integer)
    override val storageEncrypted: Option[Boolean] =
      scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbClusterIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterSnapshotIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbClusterSnapshotIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamDatabaseAuthenticationEnabled: Option[Boolean] = scala
      .Option(impl.iamDatabaseAuthenticationEnabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterSnapshotDetails
  ): zio.aws.securityhub.model.AwsRdsDbClusterSnapshotDetails.ReadOnly =
    new Wrapper(impl)
}
