package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterOptionGroupMembership(
    dbClusterOptionGroupName: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership = {
    import AwsRdsDbClusterOptionGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership
      .builder()
      .optionallyWith(
        dbClusterOptionGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterOptionGroupName)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership
      .wrap(buildAwsValue())
}
object AwsRdsDbClusterOptionGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership =
      zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership(
        dbClusterOptionGroupName.map(value => value),
        status.map(value => value)
      )
    def dbClusterOptionGroupName: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getDbClusterOptionGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterOptionGroupName",
        dbClusterOptionGroupName
      )
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly {
    override val dbClusterOptionGroupName: Option[NonEmptyString] = scala
      .Option(impl.dbClusterOptionGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership
  ): zio.aws.securityhub.model.AwsRdsDbClusterOptionGroupMembership.ReadOnly =
    new Wrapper(impl)
}
