package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsRdsDbClusterMember(
    isClusterWriter: Option[Boolean] = None,
    promotionTier: Option[Integer] = None,
    dbInstanceIdentifier: Option[NonEmptyString] = None,
    dbClusterParameterGroupStatus: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember = {
    import AwsRdsDbClusterMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember
      .builder()
      .optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(
        _.isClusterWriter
      )
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(
        dbInstanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbInstanceIdentifier)
      .optionallyWith(
        dbClusterParameterGroupStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.dbClusterParameterGroupStatus)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly =
    zio.aws.securityhub.model.AwsRdsDbClusterMember.wrap(buildAwsValue())
}
object AwsRdsDbClusterMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsRdsDbClusterMember =
      zio.aws.securityhub.model.AwsRdsDbClusterMember(
        isClusterWriter.map(value => value),
        promotionTier.map(value => value),
        dbInstanceIdentifier.map(value => value),
        dbClusterParameterGroupStatus.map(value => value)
      )
    def isClusterWriter: Option[Boolean]
    def promotionTier: Option[Integer]
    def dbInstanceIdentifier: Option[NonEmptyString]
    def dbClusterParameterGroupStatus: Option[NonEmptyString]
    def getIsClusterWriter: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isClusterWriter", isClusterWriter)
    def getPromotionTier: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbClusterParameterGroupStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupStatus",
        dbClusterParameterGroupStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember
  ) extends zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly {
    override val isClusterWriter: Option[Boolean] =
      scala.Option(impl.isClusterWriter()).map(value => value: Boolean)
    override val promotionTier: Option[Integer] =
      scala.Option(impl.promotionTier()).map(value => value: Integer)
    override val dbInstanceIdentifier: Option[NonEmptyString] = scala
      .Option(impl.dbInstanceIdentifier())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dbClusterParameterGroupStatus: Option[NonEmptyString] = scala
      .Option(impl.dbClusterParameterGroupStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember
  ): zio.aws.securityhub.model.AwsRdsDbClusterMember.ReadOnly = new Wrapper(
    impl
  )
}
