package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallRuleGroupDetails(
    capacity: Option[Integer] = None,
    description: Option[NonEmptyString] = None,
    ruleGroup: Option[zio.aws.securityhub.model.RuleGroupDetails] = None,
    ruleGroupArn: Option[NonEmptyString] = None,
    ruleGroupId: Option[NonEmptyString] = None,
    ruleGroupName: Option[NonEmptyString] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails = {
    import AwsNetworkFirewallRuleGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
      .builder()
      .optionallyWith(capacity.map(value => value: java.lang.Integer))(
        _.capacity
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .optionallyWith(
        ruleGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ruleGroupArn)
      .optionallyWith(
        ruleGroupId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleGroupId)
      .optionallyWith(
        ruleGroupName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ruleGroupName)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallRuleGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails(
        capacity.map(value => value),
        description.map(value => value),
        ruleGroup.map(value => value.asEditable),
        ruleGroupArn.map(value => value),
        ruleGroupId.map(value => value),
        ruleGroupName.map(value => value),
        `type`.map(value => value)
      )
    def capacity: Option[Integer]
    def description: Option[NonEmptyString]
    def ruleGroup: Option[zio.aws.securityhub.model.RuleGroupDetails.ReadOnly]
    def ruleGroupArn: Option[NonEmptyString]
    def ruleGroupId: Option[NonEmptyString]
    def ruleGroupName: Option[NonEmptyString]
    def `type`: Option[NonEmptyString]
    def getCapacity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("capacity", capacity)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRuleGroup: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.RuleGroupDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ruleGroup", ruleGroup)
    def getRuleGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getRuleGroupId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupId", ruleGroupId)
    def getRuleGroupName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleGroupName", ruleGroupName)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly {
    override val capacity: Option[Integer] =
      scala.Option(impl.capacity()).map(value => value: Integer)
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroup
        : Option[zio.aws.securityhub.model.RuleGroupDetails.ReadOnly] = scala
      .Option(impl.ruleGroup())
      .map(value => zio.aws.securityhub.model.RuleGroupDetails.wrap(value))
    override val ruleGroupArn: Option[NonEmptyString] = scala
      .Option(impl.ruleGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroupId: Option[NonEmptyString] = scala
      .Option(impl.ruleGroupId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleGroupName: Option[NonEmptyString] = scala
      .Option(impl.ruleGroupName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallRuleGroupDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallRuleGroupDetails.ReadOnly =
    new Wrapper(impl)
}
