package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallFirewallPolicyDetails(
    firewallPolicy: Option[zio.aws.securityhub.model.FirewallPolicyDetails] =
      None,
    firewallPolicyArn: Option[NonEmptyString] = None,
    firewallPolicyId: Option[NonEmptyString] = None,
    firewallPolicyName: Option[NonEmptyString] = None,
    description: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails = {
    import AwsNetworkFirewallFirewallPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
      .builder()
      .optionallyWith(firewallPolicy.map(value => value.buildAwsValue()))(
        _.firewallPolicy
      )
      .optionallyWith(
        firewallPolicyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        firewallPolicyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyId)
      .optionallyWith(
        firewallPolicyName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallFirewallPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails(
        firewallPolicy.map(value => value.asEditable),
        firewallPolicyArn.map(value => value),
        firewallPolicyId.map(value => value),
        firewallPolicyName.map(value => value),
        description.map(value => value)
      )
    def firewallPolicy
        : Option[zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly]
    def firewallPolicyArn: Option[NonEmptyString]
    def firewallPolicyId: Option[NonEmptyString]
    def firewallPolicyName: Option[NonEmptyString]
    def description: Option[NonEmptyString]
    def getFirewallPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("firewallPolicy", firewallPolicy)
    def getFirewallPolicyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getFirewallPolicyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyId", firewallPolicyId)
    def getFirewallPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyName", firewallPolicyName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly {
    override val firewallPolicy
        : Option[zio.aws.securityhub.model.FirewallPolicyDetails.ReadOnly] =
      scala
        .Option(impl.firewallPolicy())
        .map(value =>
          zio.aws.securityhub.model.FirewallPolicyDetails.wrap(value)
        )
    override val firewallPolicyArn: Option[NonEmptyString] = scala
      .Option(impl.firewallPolicyArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallPolicyId: Option[NonEmptyString] = scala
      .Option(impl.firewallPolicyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallPolicyName: Option[NonEmptyString] = scala
      .Option(impl.firewallPolicyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallFirewallPolicyDetails.ReadOnly =
    new Wrapper(impl)
}
