package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionDetails(
    code: Option[zio.aws.securityhub.model.AwsLambdaFunctionCode] = None,
    codeSha256: Option[NonEmptyString] = None,
    deadLetterConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig
    ] = None,
    environment: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment
    ] = None,
    functionName: Option[NonEmptyString] = None,
    handler: Option[NonEmptyString] = None,
    kmsKeyArn: Option[NonEmptyString] = None,
    lastModified: Option[NonEmptyString] = None,
    layers: Option[Iterable[zio.aws.securityhub.model.AwsLambdaFunctionLayer]] =
      None,
    masterArn: Option[NonEmptyString] = None,
    memorySize: Option[Integer] = None,
    revisionId: Option[NonEmptyString] = None,
    role: Option[NonEmptyString] = None,
    runtime: Option[NonEmptyString] = None,
    timeout: Option[Integer] = None,
    tracingConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig
    ] = None,
    vpcConfig: Option[zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig] =
      None,
    version: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails = {
    import AwsLambdaFunctionDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
      .builder()
      .optionallyWith(code.map(value => value.buildAwsValue()))(_.code)
      .optionallyWith(
        codeSha256.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.codeSha256)
      .optionallyWith(deadLetterConfig.map(value => value.buildAwsValue()))(
        _.deadLetterConfig
      )
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .optionallyWith(
        functionName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.functionName)
      .optionallyWith(
        handler.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.handler)
      .optionallyWith(
        kmsKeyArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .optionallyWith(
        lastModified.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        layers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.layers)
      .optionallyWith(
        masterArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.masterArn)
      .optionallyWith(memorySize.map(value => value: java.lang.Integer))(
        _.memorySize
      )
      .optionallyWith(
        revisionId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        role.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        runtime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.runtime)
      .optionallyWith(timeout.map(value => value: java.lang.Integer))(_.timeout)
      .optionallyWith(tracingConfig.map(value => value.buildAwsValue()))(
        _.tracingConfig
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionDetails.wrap(buildAwsValue())
}
object AwsLambdaFunctionDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionDetails =
      zio.aws.securityhub.model.AwsLambdaFunctionDetails(
        code.map(value => value.asEditable),
        codeSha256.map(value => value),
        deadLetterConfig.map(value => value.asEditable),
        environment.map(value => value.asEditable),
        functionName.map(value => value),
        handler.map(value => value),
        kmsKeyArn.map(value => value),
        lastModified.map(value => value),
        layers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        masterArn.map(value => value),
        memorySize.map(value => value),
        revisionId.map(value => value),
        role.map(value => value),
        runtime.map(value => value),
        timeout.map(value => value),
        tracingConfig.map(value => value.asEditable),
        vpcConfig.map(value => value.asEditable),
        version.map(value => value)
      )
    def code: Option[zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly]
    def codeSha256: Option[NonEmptyString]
    def deadLetterConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ]
    def environment: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ]
    def functionName: Option[NonEmptyString]
    def handler: Option[NonEmptyString]
    def kmsKeyArn: Option[NonEmptyString]
    def lastModified: Option[NonEmptyString]
    def layers: Option[
      List[zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly]
    ]
    def masterArn: Option[NonEmptyString]
    def memorySize: Option[Integer]
    def revisionId: Option[NonEmptyString]
    def role: Option[NonEmptyString]
    def runtime: Option[NonEmptyString]
    def timeout: Option[Integer]
    def tracingConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ]
    def vpcConfig
        : Option[zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly]
    def version: Option[NonEmptyString]
    def getCode: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly
    ] = AwsError.unwrapOptionField("code", code)
    def getCodeSha256: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("codeSha256", codeSha256)
    def getDeadLetterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ] = AwsError.unwrapOptionField("deadLetterConfig", deadLetterConfig)
    def getEnvironment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ] = AwsError.unwrapOptionField("environment", environment)
    def getFunctionName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("functionName", functionName)
    def getHandler: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("handler", handler)
    def getKmsKeyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
    def getLastModified: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getLayers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly
    ]] = AwsError.unwrapOptionField("layers", layers)
    def getMasterArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("masterArn", masterArn)
    def getMemorySize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("memorySize", memorySize)
    def getRevisionId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("role", role)
    def getRuntime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("timeout", timeout)
    def getTracingConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ] = AwsError.unwrapOptionField("tracingConfig", tracingConfig)
    def getVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly {
    override val code
        : Option[zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly] =
      scala
        .Option(impl.code())
        .map(value =>
          zio.aws.securityhub.model.AwsLambdaFunctionCode.wrap(value)
        )
    override val codeSha256: Option[NonEmptyString] = scala
      .Option(impl.codeSha256())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deadLetterConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly
    ] = scala
      .Option(impl.deadLetterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.wrap(value)
      )
    override val environment: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.ReadOnly
    ] = scala
      .Option(impl.environment())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionEnvironment.wrap(value)
      )
    override val functionName: Option[NonEmptyString] = scala
      .Option(impl.functionName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val handler: Option[NonEmptyString] = scala
      .Option(impl.handler())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyArn: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val lastModified: Option[NonEmptyString] = scala
      .Option(impl.lastModified())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val layers: Option[
      List[zio.aws.securityhub.model.AwsLambdaFunctionLayer.ReadOnly]
    ] = scala
      .Option(impl.layers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsLambdaFunctionLayer.wrap(item)
        }.toList
      )
    override val masterArn: Option[NonEmptyString] = scala
      .Option(impl.masterArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val memorySize: Option[Integer] =
      scala.Option(impl.memorySize()).map(value => value: Integer)
    override val revisionId: Option[NonEmptyString] = scala
      .Option(impl.revisionId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val role: Option[NonEmptyString] = scala
      .Option(impl.role())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val runtime: Option[NonEmptyString] = scala
      .Option(impl.runtime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val timeout: Option[Integer] =
      scala.Option(impl.timeout()).map(value => value: Integer)
    override val tracingConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.ReadOnly
    ] = scala
      .Option(impl.tracingConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionTracingConfig.wrap(value)
      )
    override val vpcConfig: Option[
      zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.ReadOnly
    ] = scala
      .Option(impl.vpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsLambdaFunctionVpcConfig.wrap(value)
      )
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDetails
  ): zio.aws.securityhub.model.AwsLambdaFunctionDetails.ReadOnly = new Wrapper(
    impl
  )
}
