package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionDeadLetterConfig(
    targetArn: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig = {
    import AwsLambdaFunctionDeadLetterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig
      .builder()
      .optionallyWith(
        targetArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.targetArn)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig
      .wrap(buildAwsValue())
}
object AwsLambdaFunctionDeadLetterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig =
      zio.aws.securityhub.model
        .AwsLambdaFunctionDeadLetterConfig(targetArn.map(value => value))
    def targetArn: Option[NonEmptyString]
    def getTargetArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("targetArn", targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly {
    override val targetArn: Option[NonEmptyString] = scala
      .Option(impl.targetArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionDeadLetterConfig
  ): zio.aws.securityhub.model.AwsLambdaFunctionDeadLetterConfig.ReadOnly =
    new Wrapper(impl)
}
