package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsLambdaFunctionCode(
    s3Bucket: Option[NonEmptyString] = None,
    s3Key: Option[NonEmptyString] = None,
    s3ObjectVersion: Option[NonEmptyString] = None,
    zipFile: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode = {
    import AwsLambdaFunctionCode.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode
      .builder()
      .optionallyWith(
        s3Bucket.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3Bucket)
      .optionallyWith(
        s3Key.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.s3Key)
      .optionallyWith(
        s3ObjectVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.s3ObjectVersion)
      .optionallyWith(
        zipFile.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.zipFile)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly =
    zio.aws.securityhub.model.AwsLambdaFunctionCode.wrap(buildAwsValue())
}
object AwsLambdaFunctionCode {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsLambdaFunctionCode =
      zio.aws.securityhub.model.AwsLambdaFunctionCode(
        s3Bucket.map(value => value),
        s3Key.map(value => value),
        s3ObjectVersion.map(value => value),
        zipFile.map(value => value)
      )
    def s3Bucket: Option[NonEmptyString]
    def s3Key: Option[NonEmptyString]
    def s3ObjectVersion: Option[NonEmptyString]
    def zipFile: Option[NonEmptyString]
    def getS3Bucket: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Key: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3Key", s3Key)
    def getS3ObjectVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("s3ObjectVersion", s3ObjectVersion)
    def getZipFile: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("zipFile", zipFile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode
  ) extends zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly {
    override val s3Bucket: Option[NonEmptyString] = scala
      .Option(impl.s3Bucket())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3Key: Option[NonEmptyString] = scala
      .Option(impl.s3Key())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val s3ObjectVersion: Option[NonEmptyString] = scala
      .Option(impl.s3ObjectVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val zipFile: Option[NonEmptyString] = scala
      .Option(impl.zipFile())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsLambdaFunctionCode
  ): zio.aws.securityhub.model.AwsLambdaFunctionCode.ReadOnly = new Wrapper(
    impl
  )
}
