package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  Integer,
  NonEmptyString,
  AwsIamRoleAssumeRolePolicyDocument
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamRoleDetails(
    assumeRolePolicyDocument: Option[AwsIamRoleAssumeRolePolicyDocument] = None,
    attachedManagedPolicies: Option[
      Iterable[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy]
    ] = None,
    createDate: Option[NonEmptyString] = None,
    instanceProfileList: Option[
      Iterable[zio.aws.securityhub.model.AwsIamInstanceProfile]
    ] = None,
    permissionsBoundary: Option[
      zio.aws.securityhub.model.AwsIamPermissionsBoundary
    ] = None,
    roleId: Option[NonEmptyString] = None,
    roleName: Option[NonEmptyString] = None,
    rolePolicyList: Option[
      Iterable[zio.aws.securityhub.model.AwsIamRolePolicy]
    ] = None,
    maxSessionDuration: Option[Integer] = None,
    path: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails = {
    import AwsIamRoleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
      .builder()
      .optionallyWith(
        assumeRolePolicyDocument.map(value =>
          AwsIamRoleAssumeRolePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.assumeRolePolicyDocument)
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        instanceProfileList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceProfileList)
      .optionallyWith(permissionsBoundary.map(value => value.buildAwsValue()))(
        _.permissionsBoundary
      )
      .optionallyWith(
        roleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleId)
      .optionallyWith(
        roleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        rolePolicyList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rolePolicyList)
      .optionallyWith(
        maxSessionDuration.map(value => value: java.lang.Integer)
      )(_.maxSessionDuration)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsIamRoleDetails.wrap(buildAwsValue())
}
object AwsIamRoleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamRoleDetails =
      zio.aws.securityhub.model.AwsIamRoleDetails(
        assumeRolePolicyDocument.map(value => value),
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        instanceProfileList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        permissionsBoundary.map(value => value.asEditable),
        roleId.map(value => value),
        roleName.map(value => value),
        rolePolicyList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxSessionDuration.map(value => value),
        path.map(value => value)
      )
    def assumeRolePolicyDocument: Option[AwsIamRoleAssumeRolePolicyDocument]
    def attachedManagedPolicies: Option[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ]
    def createDate: Option[NonEmptyString]
    def instanceProfileList
        : Option[List[zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly]]
    def permissionsBoundary
        : Option[zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly]
    def roleId: Option[NonEmptyString]
    def roleName: Option[NonEmptyString]
    def rolePolicyList
        : Option[List[zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly]]
    def maxSessionDuration: Option[Integer]
    def path: Option[NonEmptyString]
    def getAssumeRolePolicyDocument
        : ZIO[Any, AwsError, AwsIamRoleAssumeRolePolicyDocument] = AwsError
      .unwrapOptionField("assumeRolePolicyDocument", assumeRolePolicyDocument)
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getInstanceProfileList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceProfileList", instanceProfileList)
    def getPermissionsBoundary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly
    ] = AwsError.unwrapOptionField("permissionsBoundary", permissionsBoundary)
    def getRoleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleId", roleId)
    def getRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getRolePolicyList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("rolePolicyList", rolePolicyList)
    def getMaxSessionDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSessionDuration", maxSessionDuration)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ) extends zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly {
    override val assumeRolePolicyDocument
        : Option[AwsIamRoleAssumeRolePolicyDocument] = scala
      .Option(impl.assumeRolePolicyDocument())
      .map(value =>
        zio.aws.securityhub.model.primitives
          .AwsIamRoleAssumeRolePolicyDocument(value)
      )
    override val attachedManagedPolicies: Option[
      List[zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.ReadOnly]
    ] = scala
      .Option(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamAttachedManagedPolicy.wrap(item)
        }.toList
      )
    override val createDate: Option[NonEmptyString] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceProfileList: Option[
      List[zio.aws.securityhub.model.AwsIamInstanceProfile.ReadOnly]
    ] = scala
      .Option(impl.instanceProfileList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsIamInstanceProfile.wrap(item)
        }.toList
      )
    override val permissionsBoundary
        : Option[zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly] =
      scala
        .Option(impl.permissionsBoundary())
        .map(value =>
          zio.aws.securityhub.model.AwsIamPermissionsBoundary.wrap(value)
        )
    override val roleId: Option[NonEmptyString] = scala
      .Option(impl.roleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleName: Option[NonEmptyString] = scala
      .Option(impl.roleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rolePolicyList
        : Option[List[zio.aws.securityhub.model.AwsIamRolePolicy.ReadOnly]] =
      scala
        .Option(impl.rolePolicyList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsIamRolePolicy.wrap(item)
          }.toList
        )
    override val maxSessionDuration: Option[Integer] =
      scala.Option(impl.maxSessionDuration()).map(value => value: Integer)
    override val path: Option[NonEmptyString] = scala
      .Option(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamRoleDetails
  ): zio.aws.securityhub.model.AwsIamRoleDetails.ReadOnly = new Wrapper(impl)
}
