package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamPermissionsBoundary(
    permissionsBoundaryArn: Option[NonEmptyString] = None,
    permissionsBoundaryType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary = {
    import AwsIamPermissionsBoundary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary
      .builder()
      .optionallyWith(
        permissionsBoundaryArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.permissionsBoundaryArn)
      .optionallyWith(
        permissionsBoundaryType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.permissionsBoundaryType)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly =
    zio.aws.securityhub.model.AwsIamPermissionsBoundary.wrap(buildAwsValue())
}
object AwsIamPermissionsBoundary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamPermissionsBoundary =
      zio.aws.securityhub.model.AwsIamPermissionsBoundary(
        permissionsBoundaryArn.map(value => value),
        permissionsBoundaryType.map(value => value)
      )
    def permissionsBoundaryArn: Option[NonEmptyString]
    def permissionsBoundaryType: Option[NonEmptyString]
    def getPermissionsBoundaryArn: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("permissionsBoundaryArn", permissionsBoundaryArn)
    def getPermissionsBoundaryType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "permissionsBoundaryType",
        permissionsBoundaryType
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary
  ) extends zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly {
    override val permissionsBoundaryArn: Option[NonEmptyString] = scala
      .Option(impl.permissionsBoundaryArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val permissionsBoundaryType: Option[NonEmptyString] = scala
      .Option(impl.permissionsBoundaryType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamPermissionsBoundary
  ): zio.aws.securityhub.model.AwsIamPermissionsBoundary.ReadOnly = new Wrapper(
    impl
  )
}
