package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamGroupPolicy(policyName: Option[NonEmptyString] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamGroupPolicy = {
    import AwsIamGroupPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamGroupPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsIamGroupPolicy.wrap(buildAwsValue())
}
object AwsIamGroupPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamGroupPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamGroupPolicy =
      zio.aws.securityhub.model
        .AwsIamGroupPolicy(policyName.map(value => value))
    def policyName: Option[NonEmptyString]
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamGroupPolicy
  ) extends zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly {
    override val policyName: Option[NonEmptyString] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamGroupPolicy
  ): zio.aws.securityhub.model.AwsIamGroupPolicy.ReadOnly = new Wrapper(impl)
}
