package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsIamAccessKeySessionContextSessionIssuer(
    `type`: Option[NonEmptyString] = None,
    principalId: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None,
    accountId: Option[NonEmptyString] = None,
    userName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer = {
    import AwsIamAccessKeySessionContextSessionIssuer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        principalId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        userName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly =
    zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
      .wrap(buildAwsValue())
}
object AwsIamAccessKeySessionContextSessionIssuer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer =
      zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer(
        `type`.map(value => value),
        principalId.map(value => value),
        arn.map(value => value),
        accountId.map(value => value),
        userName.map(value => value)
      )
    def `type`: Option[NonEmptyString]
    def principalId: Option[NonEmptyString]
    def arn: Option[NonEmptyString]
    def accountId: Option[NonEmptyString]
    def userName: Option[NonEmptyString]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getPrincipalId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getUserName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userName", userName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ) extends zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly {
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val principalId: Option[NonEmptyString] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val accountId: Option[NonEmptyString] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val userName: Option[NonEmptyString] = scala
      .Option(impl.userName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer
  ): zio.aws.securityhub.model.AwsIamAccessKeySessionContextSessionIssuer.ReadOnly =
    new Wrapper(impl)
}
