package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbv2LoadBalancerDetails(
    availabilityZones: Option[
      Iterable[zio.aws.securityhub.model.AvailabilityZone]
    ] = None,
    canonicalHostedZoneId: Option[NonEmptyString] = None,
    createdTime: Option[NonEmptyString] = None,
    dnsName: Option[NonEmptyString] = None,
    ipAddressType: Option[NonEmptyString] = None,
    scheme: Option[NonEmptyString] = None,
    securityGroups: Option[Iterable[NonEmptyString]] = None,
    state: Option[zio.aws.securityhub.model.LoadBalancerState] = None,
    `type`: Option[NonEmptyString] = None,
    vpcId: Option[NonEmptyString] = None,
    loadBalancerAttributes: Option[
      Iterable[zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails = {
    import AwsElbv2LoadBalancerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        canonicalHostedZoneId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneId)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(
        dnsName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        ipAddressType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ipAddressType)
      .optionallyWith(
        scheme.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scheme)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        loadBalancerAttributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancerAttributes)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.wrap(buildAwsValue())
}
object AwsElbv2LoadBalancerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails =
      zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails(
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        canonicalHostedZoneId.map(value => value),
        createdTime.map(value => value),
        dnsName.map(value => value),
        ipAddressType.map(value => value),
        scheme.map(value => value),
        securityGroups.map(value => value),
        state.map(value => value.asEditable),
        `type`.map(value => value),
        vpcId.map(value => value),
        loadBalancerAttributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def availabilityZones
        : Option[List[zio.aws.securityhub.model.AvailabilityZone.ReadOnly]]
    def canonicalHostedZoneId: Option[NonEmptyString]
    def createdTime: Option[NonEmptyString]
    def dnsName: Option[NonEmptyString]
    def ipAddressType: Option[NonEmptyString]
    def scheme: Option[NonEmptyString]
    def securityGroups: Option[List[NonEmptyString]]
    def state: Option[zio.aws.securityhub.model.LoadBalancerState.ReadOnly]
    def `type`: Option[NonEmptyString]
    def vpcId: Option[NonEmptyString]
    def loadBalancerAttributes: Option[
      List[zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly]
    ]
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getCanonicalHostedZoneId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("canonicalHostedZoneId", canonicalHostedZoneId)
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getIpAddressType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getScheme: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scheme", scheme)
    def getSecurityGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.LoadBalancerState.ReadOnly
    ] = AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getLoadBalancerAttributes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "loadBalancerAttributes",
      loadBalancerAttributes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails
  ) extends zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly {
    override val availabilityZones
        : Option[List[zio.aws.securityhub.model.AvailabilityZone.ReadOnly]] =
      scala
        .Option(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AvailabilityZone.wrap(item)
          }.toList
        )
    override val canonicalHostedZoneId: Option[NonEmptyString] = scala
      .Option(impl.canonicalHostedZoneId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdTime: Option[NonEmptyString] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dnsName: Option[NonEmptyString] = scala
      .Option(impl.dnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipAddressType: Option[NonEmptyString] = scala
      .Option(impl.ipAddressType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val scheme: Option[NonEmptyString] = scala
      .Option(impl.scheme())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val state
        : Option[zio.aws.securityhub.model.LoadBalancerState.ReadOnly] = scala
      .Option(impl.state())
      .map(value => zio.aws.securityhub.model.LoadBalancerState.wrap(value))
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val vpcId: Option[NonEmptyString] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loadBalancerAttributes: Option[
      List[zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.ReadOnly]
    ] = scala
      .Option(impl.loadBalancerAttributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsElbv2LoadBalancerAttribute.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbv2LoadBalancerDetails
  ): zio.aws.securityhub.model.AwsElbv2LoadBalancerDetails.ReadOnly =
    new Wrapper(impl)
}
