package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerCrossZoneLoadBalancing(
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing = {
    import AwsElbLoadBalancerCrossZoneLoadBalancing.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerCrossZoneLoadBalancing {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing =
      zio.aws.securityhub.model
        .AwsElbLoadBalancerCrossZoneLoadBalancing(enabled.map(value => value))
    def enabled: Option[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing
  ): zio.aws.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing.ReadOnly =
    new Wrapper(impl)
}
