package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElbLbCookieStickinessPolicy(
    cookieExpirationPeriod: Option[Long] = None,
    policyName: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy = {
    import AwsElbLbCookieStickinessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
      .builder()
      .optionallyWith(
        cookieExpirationPeriod.map(value => value: java.lang.Long)
      )(_.cookieExpirationPeriod)
      .optionallyWith(
        policyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.policyName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly =
    zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy
      .wrap(buildAwsValue())
}
object AwsElbLbCookieStickinessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy =
      zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy(
        cookieExpirationPeriod.map(value => value),
        policyName.map(value => value)
      )
    def cookieExpirationPeriod: Option[Long]
    def policyName: Option[NonEmptyString]
    def getCookieExpirationPeriod: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("cookieExpirationPeriod", cookieExpirationPeriod)
    def getPolicyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("policyName", policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ) extends zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly {
    override val cookieExpirationPeriod: Option[Long] =
      scala.Option(impl.cookieExpirationPeriod()).map(value => value: Long)
    override val policyName: Option[NonEmptyString] = scala
      .Option(impl.policyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLbCookieStickinessPolicy
  ): zio.aws.securityhub.model.AwsElbLbCookieStickinessPolicy.ReadOnly =
    new Wrapper(impl)
}
