package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainLogPublishingOptionsLogConfig(
    cloudWatchLogsLogGroupArn: Option[NonEmptyString] = None,
    enabled: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig = {
    import AwsElasticsearchDomainLogPublishingOptionsLogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
      .builder()
      .optionallyWith(
        cloudWatchLogsLogGroupArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogsLogGroupArn)
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainLogPublishingOptionsLogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig =
      zio.aws.securityhub.model
        .AwsElasticsearchDomainLogPublishingOptionsLogConfig(
          cloudWatchLogsLogGroupArn.map(value => value),
          enabled.map(value => value)
        )
    def cloudWatchLogsLogGroupArn: Option[NonEmptyString]
    def enabled: Option[Boolean]
    def getCloudWatchLogsLogGroupArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "cloudWatchLogsLogGroupArn",
        cloudWatchLogsLogGroupArn
      )
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly {
    override val cloudWatchLogsLogGroupArn: Option[NonEmptyString] = scala
      .Option(impl.cloudWatchLogsLogGroupArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig
  ): zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptionsLogConfig.ReadOnly =
    new Wrapper(impl)
}
