package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainDomainEndpointOptions(
    enforceHTTPS: Option[Boolean] = None,
    tlsSecurityPolicy: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions = {
    import AwsElasticsearchDomainDomainEndpointOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
      .builder()
      .optionallyWith(enforceHTTPS.map(value => value: java.lang.Boolean))(
        _.enforceHTTPS
      )
      .optionallyWith(
        tlsSecurityPolicy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.tlsSecurityPolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainDomainEndpointOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions =
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions(
        enforceHTTPS.map(value => value),
        tlsSecurityPolicy.map(value => value)
      )
    def enforceHTTPS: Option[Boolean]
    def tlsSecurityPolicy: Option[NonEmptyString]
    def getEnforceHTTPS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforceHTTPS", enforceHTTPS)
    def getTlsSecurityPolicy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("tlsSecurityPolicy", tlsSecurityPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly {
    override val enforceHTTPS: Option[Boolean] =
      scala.Option(impl.enforceHTTPS()).map(value => value: Boolean)
    override val tlsSecurityPolicy: Option[NonEmptyString] = scala
      .Option(impl.tlsSecurityPolicy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly =
    new Wrapper(impl)
}
