package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainDetails(
    accessPolicies: Option[NonEmptyString] = None,
    domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
    ] = None,
    domainId: Option[NonEmptyString] = None,
    domainName: Option[NonEmptyString] = None,
    endpoint: Option[NonEmptyString] = None,
    endpoints: Option[Map[NonEmptyString, NonEmptyString]] = None,
    elasticsearchVersion: Option[NonEmptyString] = None,
    elasticsearchClusterConfig: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
    ] = None,
    encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
    ] = None,
    logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
    ] = None,
    nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
    ] = None,
    serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions
    ] = None,
    vpcOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails = {
    import AwsElasticsearchDomainDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
      .builder()
      .optionallyWith(
        accessPolicies.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        domainId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainId)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        endpoints.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.endpoints)
      .optionallyWith(
        elasticsearchVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.elasticsearchVersion)
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(logPublishingOptions.map(value => value.buildAwsValue()))(
        _.logPublishingOptions
      )
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainDetails
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsElasticsearchDomainDetails =
      zio.aws.securityhub.model.AwsElasticsearchDomainDetails(
        accessPolicies.map(value => value),
        domainEndpointOptions.map(value => value.asEditable),
        domainId.map(value => value),
        domainName.map(value => value),
        endpoint.map(value => value),
        endpoints.map(value => value),
        elasticsearchVersion.map(value => value),
        elasticsearchClusterConfig.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        logPublishingOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        serviceSoftwareOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable)
      )
    def accessPolicies: Option[NonEmptyString]
    def domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ]
    def domainId: Option[NonEmptyString]
    def domainName: Option[NonEmptyString]
    def endpoint: Option[NonEmptyString]
    def endpoints: Option[Map[NonEmptyString, NonEmptyString]]
    def elasticsearchVersion: Option[NonEmptyString]
    def elasticsearchClusterConfig: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ]
    def encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ]
    def logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ]
    def serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ]
    def vpcOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ]
    def getAccessPolicies: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getDomainId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainId", domainId)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getEndpoints: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("endpoints", endpoints)
    def getElasticsearchVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("elasticsearchVersion", elasticsearchVersion)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getLogPublishingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
    def getVpcOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ] = AwsError.unwrapOptionField("vpcOptions", vpcOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly {
    override val accessPolicies: Option[NonEmptyString] = scala
      .Option(impl.accessPolicies())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainEndpointOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions.ReadOnly
    ] = scala
      .Option(impl.domainEndpointOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainDomainEndpointOptions
          .wrap(value)
      )
    override val domainId: Option[NonEmptyString] = scala
      .Option(impl.domainId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Option[NonEmptyString] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoints: Option[Map[NonEmptyString, NonEmptyString]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val elasticsearchVersion: Option[NonEmptyString] = scala
      .Option(impl.elasticsearchVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val elasticsearchClusterConfig: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails.ReadOnly
    ] = scala
      .Option(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainElasticsearchClusterConfigDetails
          .wrap(value)
      )
    override val encryptionAtRestOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly
    ] = scala
      .Option(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
          .wrap(value)
      )
    override val logPublishingOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions.ReadOnly
    ] = scala
      .Option(impl.logPublishingOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainLogPublishingOptions
          .wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions.ReadOnly
    ] = scala
      .Option(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainNodeToNodeEncryptionOptions
          .wrap(value)
      )
    override val serviceSoftwareOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions.ReadOnly
    ] = scala
      .Option(impl.serviceSoftwareOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainServiceSoftwareOptions
          .wrap(value)
      )
    override val vpcOptions: Option[
      zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.ReadOnly
    ] = scala
      .Option(impl.vpcOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsElasticsearchDomainVPCOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainDetails
  ): zio.aws.securityhub.model.AwsElasticsearchDomainDetails.ReadOnly =
    new Wrapper(impl)
}
