package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEksClusterDetails(
    arn: Option[NonEmptyString] = None,
    certificateAuthorityData: Option[NonEmptyString] = None,
    clusterStatus: Option[NonEmptyString] = None,
    endpoint: Option[NonEmptyString] = None,
    name: Option[NonEmptyString] = None,
    resourcesVpcConfig: Option[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
    ] = None,
    roleArn: Option[NonEmptyString] = None,
    version: Option[NonEmptyString] = None,
    logging: Option[zio.aws.securityhub.model.AwsEksClusterLoggingDetails] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails = {
    import AwsEksClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        certificateAuthorityData.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityData)
      .optionallyWith(
        clusterStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.clusterStatus)
      .optionallyWith(
        endpoint.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.endpoint)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(resourcesVpcConfig.map(value => value.buildAwsValue()))(
        _.resourcesVpcConfig
      )
      .optionallyWith(
        roleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterDetails.wrap(buildAwsValue())
}
object AwsEksClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEksClusterDetails =
      zio.aws.securityhub.model.AwsEksClusterDetails(
        arn.map(value => value),
        certificateAuthorityData.map(value => value),
        clusterStatus.map(value => value),
        endpoint.map(value => value),
        name.map(value => value),
        resourcesVpcConfig.map(value => value.asEditable),
        roleArn.map(value => value),
        version.map(value => value),
        logging.map(value => value.asEditable)
      )
    def arn: Option[NonEmptyString]
    def certificateAuthorityData: Option[NonEmptyString]
    def clusterStatus: Option[NonEmptyString]
    def endpoint: Option[NonEmptyString]
    def name: Option[NonEmptyString]
    def resourcesVpcConfig: Option[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ]
    def roleArn: Option[NonEmptyString]
    def version: Option[NonEmptyString]
    def logging
        : Option[zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getCertificateAuthorityData: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "certificateAuthorityData",
        certificateAuthorityData
      )
    def getClusterStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterStatus", clusterStatus)
    def getEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getResourcesVpcConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("resourcesVpcConfig", resourcesVpcConfig)
    def getRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getLogging: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly
    ] = AwsError.unwrapOptionField("logging", logging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly {
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val certificateAuthorityData: Option[NonEmptyString] = scala
      .Option(impl.certificateAuthorityData())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val clusterStatus: Option[NonEmptyString] = scala
      .Option(impl.clusterStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val endpoint: Option[NonEmptyString] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourcesVpcConfig: Option[
      zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails.ReadOnly
    ] = scala
      .Option(impl.resourcesVpcConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsEksClusterResourcesVpcConfigDetails
          .wrap(value)
      )
    override val roleArn: Option[NonEmptyString] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val version: Option[NonEmptyString] = scala
      .Option(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val logging: Option[
      zio.aws.securityhub.model.AwsEksClusterLoggingDetails.ReadOnly
    ] = scala
      .Option(impl.logging())
      .map(value =>
        zio.aws.securityhub.model.AwsEksClusterLoggingDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterDetails
  ): zio.aws.securityhub.model.AwsEksClusterDetails.ReadOnly = new Wrapper(impl)
}
