package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceDetails(
    capacityProviderStrategy: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
    ]] = None,
    cluster: Option[NonEmptyString] = None,
    deploymentConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
    ] = None,
    deploymentController: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails
    ] = None,
    desiredCount: Option[Integer] = None,
    enableEcsManagedTags: Option[Boolean] = None,
    enableExecuteCommand: Option[Boolean] = None,
    healthCheckGracePeriodSeconds: Option[Integer] = None,
    launchType: Option[NonEmptyString] = None,
    loadBalancers: Option[
      Iterable[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails]
    ] = None,
    name: Option[NonEmptyString] = None,
    networkConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
    ] = None,
    placementConstraints: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails
    ]] = None,
    placementStrategies: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails
    ]] = None,
    platformVersion: Option[NonEmptyString] = None,
    propagateTags: Option[NonEmptyString] = None,
    role: Option[NonEmptyString] = None,
    schedulingStrategy: Option[NonEmptyString] = None,
    serviceArn: Option[NonEmptyString] = None,
    serviceName: Option[NonEmptyString] = None,
    serviceRegistries: Option[
      Iterable[zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails]
    ] = None,
    taskDefinition: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails = {
    import AwsEcsServiceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
      .builder()
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(
        cluster.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cluster)
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(
        enableEcsManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableEcsManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: java.lang.Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(
        launchType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchType)
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategies)
      .optionallyWith(
        platformVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        propagateTags.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.propagateTags)
      .optionallyWith(
        role.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.role)
      .optionallyWith(
        schedulingStrategy.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.schedulingStrategy)
      .optionallyWith(
        serviceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceArn)
      .optionallyWith(
        serviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(
        taskDefinition.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.taskDefinition)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceDetails.wrap(buildAwsValue())
}
object AwsEcsServiceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsServiceDetails =
      zio.aws.securityhub.model.AwsEcsServiceDetails(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cluster.map(value => value),
        deploymentConfiguration.map(value => value.asEditable),
        deploymentController.map(value => value.asEditable),
        desiredCount.map(value => value),
        enableEcsManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        healthCheckGracePeriodSeconds.map(value => value),
        launchType.map(value => value),
        loadBalancers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementStrategies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformVersion.map(value => value),
        propagateTags.map(value => value),
        role.map(value => value),
        schedulingStrategy.map(value => value),
        serviceArn.map(value => value),
        serviceName.map(value => value),
        serviceRegistries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition.map(value => value)
      )
    def capacityProviderStrategy: Option[List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]]
    def cluster: Option[NonEmptyString]
    def deploymentConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ]
    def deploymentController: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ]
    def desiredCount: Option[Integer]
    def enableEcsManagedTags: Option[Boolean]
    def enableExecuteCommand: Option[Boolean]
    def healthCheckGracePeriodSeconds: Option[Integer]
    def launchType: Option[NonEmptyString]
    def loadBalancers: Option[
      List[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly]
    ]
    def name: Option[NonEmptyString]
    def networkConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ]
    def placementConstraints: Option[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]]
    def placementStrategies: Option[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]]
    def platformVersion: Option[NonEmptyString]
    def propagateTags: Option[NonEmptyString]
    def role: Option[NonEmptyString]
    def schedulingStrategy: Option[NonEmptyString]
    def serviceArn: Option[NonEmptyString]
    def serviceName: Option[NonEmptyString]
    def serviceRegistries: Option[List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]]
    def taskDefinition: Option[NonEmptyString]
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getCluster: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getDeploymentController: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getEnableEcsManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableEcsManagedTags", enableEcsManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getLaunchType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getLoadBalancers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategies: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategies", placementStrategies)
    def getPlatformVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPropagateTags: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getRole: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("role", role)
    def getSchedulingStrategy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getServiceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceRegistries: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getTaskDefinition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly {
    override val capacityProviderStrategy: Option[List[
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly
    ]] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
            .wrap(item)
        }.toList
      )
    override val cluster: Option[NonEmptyString] = scala
      .Option(impl.cluster())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deploymentConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.deploymentConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceDeploymentConfigurationDetails
          .wrap(value)
      )
    override val deploymentController: Option[
      zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails.ReadOnly
    ] = scala
      .Option(impl.deploymentController())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceDeploymentControllerDetails
          .wrap(value)
      )
    override val desiredCount: Option[Integer] =
      scala.Option(impl.desiredCount()).map(value => value: Integer)
    override val enableEcsManagedTags: Option[Boolean] =
      scala.Option(impl.enableEcsManagedTags()).map(value => value: Boolean)
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
    override val healthCheckGracePeriodSeconds: Option[Integer] = scala
      .Option(impl.healthCheckGracePeriodSeconds())
      .map(value => value: Integer)
    override val launchType: Option[NonEmptyString] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loadBalancers: Option[
      List[zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.ReadOnly]
    ] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceLoadBalancersDetails.wrap(item)
        }.toList
      )
    override val name: Option[NonEmptyString] = scala
      .Option(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkConfiguration: Option[
      zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.networkConfiguration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsServiceNetworkConfigurationDetails
          .wrap(value)
      )
    override val placementConstraints: Option[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails.ReadOnly
    ]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServicePlacementConstraintsDetails
            .wrap(item)
        }.toList
      )
    override val placementStrategies: Option[List[
      zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails.ReadOnly
    ]] = scala
      .Option(impl.placementStrategies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServicePlacementStrategiesDetails
            .wrap(item)
        }.toList
      )
    override val platformVersion: Option[NonEmptyString] = scala
      .Option(impl.platformVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val propagateTags: Option[NonEmptyString] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val role: Option[NonEmptyString] = scala
      .Option(impl.role())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val schedulingStrategy: Option[NonEmptyString] = scala
      .Option(impl.schedulingStrategy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceArn: Option[NonEmptyString] = scala
      .Option(impl.serviceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceName: Option[NonEmptyString] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val serviceRegistries: Option[List[
      zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails.ReadOnly
    ]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsServiceServiceRegistriesDetails
            .wrap(item)
        }.toList
      )
    override val taskDefinition: Option[NonEmptyString] = scala
      .Option(impl.taskDefinition())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceDetails
  ): zio.aws.securityhub.model.AwsEcsServiceDetails.ReadOnly = new Wrapper(impl)
}
