package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsServiceCapacityProviderStrategyDetails(
    base: Option[Integer] = None,
    capacityProvider: Option[NonEmptyString] = None,
    weight: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails = {
    import AwsEcsServiceCapacityProviderStrategyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
      .builder()
      .optionallyWith(base.map(value => value: java.lang.Integer))(_.base)
      .optionallyWith(
        capacityProvider.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityProvider)
      .optionallyWith(weight.map(value => value: java.lang.Integer))(_.weight)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
      .wrap(buildAwsValue())
}
object AwsEcsServiceCapacityProviderStrategyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails =
      zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails(
        base.map(value => value),
        capacityProvider.map(value => value),
        weight.map(value => value)
      )
    def base: Option[Integer]
    def capacityProvider: Option[NonEmptyString]
    def weight: Option[Integer]
    def getBase: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("base", base)
    def getCapacityProvider: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("capacityProvider", capacityProvider)
    def getWeight: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("weight", weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ) extends zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly {
    override val base: Option[Integer] =
      scala.Option(impl.base()).map(value => value: Integer)
    override val capacityProvider: Option[NonEmptyString] = scala
      .Option(impl.capacityProvider())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val weight: Option[Integer] =
      scala.Option(impl.weight()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails
  ): zio.aws.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.ReadOnly =
    new Wrapper(impl)
}
