package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEcsClusterDetails(
    capacityProviders: Option[Iterable[NonEmptyString]] = None,
    clusterSettings: Option[
      Iterable[zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails]
    ] = None,
    configuration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails
    ] = None,
    defaultCapacityProviderStrategy: Option[Iterable[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails = {
    import AwsEcsClusterDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
      .builder()
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        clusterSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusterSettings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsClusterDetails.wrap(buildAwsValue())
}
object AwsEcsClusterDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsClusterDetails =
      zio.aws.securityhub.model.AwsEcsClusterDetails(
        capacityProviders.map(value => value),
        clusterSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityProviders: Option[List[NonEmptyString]]
    def clusterSettings: Option[List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]]
    def configuration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ]
    def defaultCapacityProviderStrategy: Option[List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]]
    def getCapacityProviders: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getClusterSettings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("clusterSettings", clusterSettings)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ) extends zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly {
    override val capacityProviders: Option[List[NonEmptyString]] = scala
      .Option(impl.capacityProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val clusterSettings: Option[List[
      zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails.ReadOnly
    ]] = scala
      .Option(impl.clusterSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsClusterClusterSettingsDetails
            .wrap(item)
        }.toList
      )
    override val configuration: Option[
      zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.ReadOnly
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        zio.aws.securityhub.model.AwsEcsClusterConfigurationDetails.wrap(value)
      )
    override val defaultCapacityProviderStrategy: Option[List[
      zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails.ReadOnly
    ]] = scala
      .Option(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDetails
  ): zio.aws.securityhub.model.AwsEcsClusterDetails.ReadOnly = new Wrapper(impl)
}
