package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2VolumeDetails(
    createTime: Option[NonEmptyString] = None,
    encrypted: Option[Boolean] = None,
    size: Option[Integer] = None,
    snapshotId: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    attachments: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2VolumeAttachment]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails = {
    import AwsEc2VolumeDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
      .builder()
      .optionallyWith(
        createTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createTime)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(size.map(value => value: java.lang.Integer))(_.size)
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2VolumeDetails.wrap(buildAwsValue())
}
object AwsEc2VolumeDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2VolumeDetails =
      zio.aws.securityhub.model.AwsEc2VolumeDetails(
        createTime.map(value => value),
        encrypted.map(value => value),
        size.map(value => value),
        snapshotId.map(value => value),
        status.map(value => value),
        kmsKeyId.map(value => value),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def createTime: Option[NonEmptyString]
    def encrypted: Option[Boolean]
    def size: Option[Integer]
    def snapshotId: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def kmsKeyId: Option[NonEmptyString]
    def attachments: Option[
      List[zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly]
    ]
    def getCreateTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("size", size)
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ) extends zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly {
    override val createTime: Option[NonEmptyString] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val size: Option[Integer] =
      scala.Option(impl.size()).map(value => value: Integer)
    override val snapshotId: Option[NonEmptyString] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val attachments: Option[
      List[zio.aws.securityhub.model.AwsEc2VolumeAttachment.ReadOnly]
    ] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2VolumeAttachment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2VolumeDetails
  ): zio.aws.securityhub.model.AwsEc2VolumeDetails.ReadOnly = new Wrapper(impl)
}
