package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfaceDetails(
    attachment: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment
    ] = None,
    networkInterfaceId: Option[NonEmptyString] = None,
    securityGroups: Option[
      Iterable[zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup]
    ] = None,
    sourceDestCheck: Option[Boolean] = None,
    ipV6Addresses: Option[Iterable[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
    ]] = None,
    privateIpAddresses: Option[Iterable[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
    ]] = None,
    publicDnsName: Option[NonEmptyString] = None,
    publicIp: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails = {
    import AwsEc2NetworkInterfaceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(sourceDestCheck.map(value => value: java.lang.Boolean))(
        _.sourceDestCheck
      )
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        publicDnsName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.publicDnsName)
      .optionallyWith(
        publicIp.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.publicIp)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails =
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails(
        attachment.map(value => value.asEditable),
        networkInterfaceId.map(value => value),
        securityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceDestCheck.map(value => value),
        ipV6Addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privateIpAddresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publicDnsName.map(value => value),
        publicIp.map(value => value)
      )
    def attachment: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ]
    def networkInterfaceId: Option[NonEmptyString]
    def securityGroups: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]]
    def sourceDestCheck: Option[Boolean]
    def ipV6Addresses: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]]
    def privateIpAddresses: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]]
    def publicDnsName: Option[NonEmptyString]
    def publicIp: Option[NonEmptyString]
    def getAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ] = AwsError.unwrapOptionField("attachment", attachment)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getSourceDestCheck: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getIpV6Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getPublicDnsName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicDnsName", publicDnsName)
    def getPublicIp: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("publicIp", publicIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly {
    override val attachment: Option[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly
    ] = scala
      .Option(impl.attachment())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.wrap(value)
      )
    override val networkInterfaceId: Option[NonEmptyString] = scala
      .Option(impl.networkInterfaceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val securityGroups: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup.ReadOnly
    ]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfaceSecurityGroup
            .wrap(item)
        }.toList
      )
    override val sourceDestCheck: Option[Boolean] =
      scala.Option(impl.sourceDestCheck()).map(value => value: Boolean)
    override val ipV6Addresses: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail.ReadOnly
    ]] = scala
      .Option(impl.ipV6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfaceIpV6AddressDetail
            .wrap(item)
        }.toList
      )
    override val privateIpAddresses: Option[List[
      zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail.ReadOnly
    ]] = scala
      .Option(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2NetworkInterfacePrivateIpAddressDetail
            .wrap(item)
        }.toList
      )
    override val publicDnsName: Option[NonEmptyString] = scala
      .Option(impl.publicDnsName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val publicIp: Option[NonEmptyString] = scala
      .Option(impl.publicIp())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceDetails
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfaceDetails.ReadOnly =
    new Wrapper(impl)
}
