package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkInterfaceAttachment(
    attachTime: Option[NonEmptyString] = None,
    attachmentId: Option[NonEmptyString] = None,
    deleteOnTermination: Option[Boolean] = None,
    deviceIndex: Option[Integer] = None,
    instanceId: Option[NonEmptyString] = None,
    instanceOwnerId: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment = {
    import AwsEc2NetworkInterfaceAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment
      .builder()
      .optionallyWith(
        attachTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.attachTime)
      .optionallyWith(
        attachmentId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.attachmentId)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(
        instanceId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        instanceOwnerId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.instanceOwnerId)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment
      .wrap(buildAwsValue())
}
object AwsEc2NetworkInterfaceAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment =
      zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment(
        attachTime.map(value => value),
        attachmentId.map(value => value),
        deleteOnTermination.map(value => value),
        deviceIndex.map(value => value),
        instanceId.map(value => value),
        instanceOwnerId.map(value => value),
        status.map(value => value)
      )
    def attachTime: Option[NonEmptyString]
    def attachmentId: Option[NonEmptyString]
    def deleteOnTermination: Option[Boolean]
    def deviceIndex: Option[Integer]
    def instanceId: Option[NonEmptyString]
    def instanceOwnerId: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getAttachTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attachTime", attachTime)
    def getAttachmentId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getInstanceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceOwnerId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("instanceOwnerId", instanceOwnerId)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment
  ) extends zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly {
    override val attachTime: Option[NonEmptyString] = scala
      .Option(impl.attachTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val attachmentId: Option[NonEmptyString] = scala
      .Option(impl.attachmentId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deleteOnTermination: Option[Boolean] =
      scala.Option(impl.deleteOnTermination()).map(value => value: Boolean)
    override val deviceIndex: Option[Integer] =
      scala.Option(impl.deviceIndex()).map(value => value: Integer)
    override val instanceId: Option[NonEmptyString] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val instanceOwnerId: Option[NonEmptyString] = scala
      .Option(impl.instanceOwnerId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkInterfaceAttachment
  ): zio.aws.securityhub.model.AwsEc2NetworkInterfaceAttachment.ReadOnly =
    new Wrapper(impl)
}
