package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsEc2NetworkAclEntry(
    cidrBlock: Option[NonEmptyString] = None,
    egress: Option[Boolean] = None,
    icmpTypeCode: Option[zio.aws.securityhub.model.IcmpTypeCode] = None,
    ipv6CidrBlock: Option[NonEmptyString] = None,
    portRange: Option[zio.aws.securityhub.model.PortRangeFromTo] = None,
    protocol: Option[NonEmptyString] = None,
    ruleAction: Option[NonEmptyString] = None,
    ruleNumber: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry = {
    import AwsEc2NetworkAclEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry
      .builder()
      .optionallyWith(
        cidrBlock.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.cidrBlock)
      .optionallyWith(egress.map(value => value: java.lang.Boolean))(_.egress)
      .optionallyWith(icmpTypeCode.map(value => value.buildAwsValue()))(
        _.icmpTypeCode
      )
      .optionallyWith(
        ipv6CidrBlock.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.ipv6CidrBlock)
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .optionallyWith(
        ruleAction.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleAction)
      .optionallyWith(ruleNumber.map(value => value: java.lang.Integer))(
        _.ruleNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly =
    zio.aws.securityhub.model.AwsEc2NetworkAclEntry.wrap(buildAwsValue())
}
object AwsEc2NetworkAclEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2NetworkAclEntry =
      zio.aws.securityhub.model.AwsEc2NetworkAclEntry(
        cidrBlock.map(value => value),
        egress.map(value => value),
        icmpTypeCode.map(value => value.asEditable),
        ipv6CidrBlock.map(value => value),
        portRange.map(value => value.asEditable),
        protocol.map(value => value),
        ruleAction.map(value => value),
        ruleNumber.map(value => value)
      )
    def cidrBlock: Option[NonEmptyString]
    def egress: Option[Boolean]
    def icmpTypeCode: Option[zio.aws.securityhub.model.IcmpTypeCode.ReadOnly]
    def ipv6CidrBlock: Option[NonEmptyString]
    def portRange: Option[zio.aws.securityhub.model.PortRangeFromTo.ReadOnly]
    def protocol: Option[NonEmptyString]
    def ruleAction: Option[NonEmptyString]
    def ruleNumber: Option[Integer]
    def getCidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getEgress: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("egress", egress)
    def getIcmpTypeCode
        : ZIO[Any, AwsError, zio.aws.securityhub.model.IcmpTypeCode.ReadOnly] =
      AwsError.unwrapOptionField("icmpTypeCode", icmpTypeCode)
    def getIpv6CidrBlock: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getPortRange: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.PortRangeFromTo.ReadOnly
    ] = AwsError.unwrapOptionField("portRange", portRange)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getRuleAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ruleNumber", ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry
  ) extends zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly {
    override val cidrBlock: Option[NonEmptyString] = scala
      .Option(impl.cidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val egress: Option[Boolean] =
      scala.Option(impl.egress()).map(value => value: Boolean)
    override val icmpTypeCode
        : Option[zio.aws.securityhub.model.IcmpTypeCode.ReadOnly] = scala
      .Option(impl.icmpTypeCode())
      .map(value => zio.aws.securityhub.model.IcmpTypeCode.wrap(value))
    override val ipv6CidrBlock: Option[NonEmptyString] = scala
      .Option(impl.ipv6CidrBlock())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val portRange
        : Option[zio.aws.securityhub.model.PortRangeFromTo.ReadOnly] = scala
      .Option(impl.portRange())
      .map(value => zio.aws.securityhub.model.PortRangeFromTo.wrap(value))
    override val protocol: Option[NonEmptyString] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleAction: Option[NonEmptyString] = scala
      .Option(impl.ruleAction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleNumber: Option[Integer] =
      scala.Option(impl.ruleNumber()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2NetworkAclEntry
  ): zio.aws.securityhub.model.AwsEc2NetworkAclEntry.ReadOnly = new Wrapper(
    impl
  )
}
