package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableStreamSpecification(
    streamEnabled: Option[Boolean] = None,
    streamViewType: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification = {
    import AwsDynamoDbTableStreamSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification
      .builder()
      .optionallyWith(streamEnabled.map(value => value: java.lang.Boolean))(
        _.streamEnabled
      )
      .optionallyWith(
        streamViewType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.streamViewType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableStreamSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification =
      zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification(
        streamEnabled.map(value => value),
        streamViewType.map(value => value)
      )
    def streamEnabled: Option[Boolean]
    def streamViewType: Option[NonEmptyString]
    def getStreamEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("streamEnabled", streamEnabled)
    def getStreamViewType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly {
    override val streamEnabled: Option[Boolean] =
      scala.Option(impl.streamEnabled()).map(value => value: Boolean)
    override val streamViewType: Option[NonEmptyString] = scala
      .Option(impl.streamViewType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableStreamSpecification
  ): zio.aws.securityhub.model.AwsDynamoDbTableStreamSpecification.ReadOnly =
    new Wrapper(impl)
}
