package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectLogsConfigS3LogsDetails(
    encryptionDisabled: Option[Boolean] = None,
    location: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails = {
    import AwsCodeBuildProjectLogsConfigS3LogsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
      .builder()
      .optionallyWith(
        encryptionDisabled.map(value => value: java.lang.Boolean)
      )(_.encryptionDisabled)
      .optionallyWith(
        location.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectLogsConfigS3LogsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails =
      zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails(
        encryptionDisabled.map(value => value),
        location.map(value => value),
        status.map(value => value)
      )
    def encryptionDisabled: Option[Boolean]
    def location: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def getEncryptionDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptionDisabled", encryptionDisabled)
    def getLocation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("location", location)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly {
    override val encryptionDisabled: Option[Boolean] =
      scala.Option(impl.encryptionDisabled()).map(value => value: Boolean)
    override val location: Option[NonEmptyString] = scala
      .Option(impl.location())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails
  ): zio.aws.securityhub.model.AwsCodeBuildProjectLogsConfigS3LogsDetails.ReadOnly =
    new Wrapper(impl)
}
