package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionViewerCertificate(
    acmCertificateArn: Option[NonEmptyString] = None,
    certificate: Option[NonEmptyString] = None,
    certificateSource: Option[NonEmptyString] = None,
    cloudFrontDefaultCertificate: Option[Boolean] = None,
    iamCertificateId: Option[NonEmptyString] = None,
    minimumProtocolVersion: Option[NonEmptyString] = None,
    sslSupportMethod: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate = {
    import AwsCloudFrontDistributionViewerCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate
      .builder()
      .optionallyWith(
        acmCertificateArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.acmCertificateArn)
      .optionallyWith(
        certificate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(
        certificateSource.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateSource)
      .optionallyWith(
        cloudFrontDefaultCertificate.map(value => value: java.lang.Boolean)
      )(_.cloudFrontDefaultCertificate)
      .optionallyWith(
        iamCertificateId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamCertificateId)
      .optionallyWith(
        minimumProtocolVersion.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.minimumProtocolVersion)
      .optionallyWith(
        sslSupportMethod.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sslSupportMethod)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionViewerCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate =
      zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate(
        acmCertificateArn.map(value => value),
        certificate.map(value => value),
        certificateSource.map(value => value),
        cloudFrontDefaultCertificate.map(value => value),
        iamCertificateId.map(value => value),
        minimumProtocolVersion.map(value => value),
        sslSupportMethod.map(value => value)
      )
    def acmCertificateArn: Option[NonEmptyString]
    def certificate: Option[NonEmptyString]
    def certificateSource: Option[NonEmptyString]
    def cloudFrontDefaultCertificate: Option[Boolean]
    def iamCertificateId: Option[NonEmptyString]
    def minimumProtocolVersion: Option[NonEmptyString]
    def sslSupportMethod: Option[NonEmptyString]
    def getAcmCertificateArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("acmCertificateArn", acmCertificateArn)
    def getCertificate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("certificateSource", certificateSource)
    def getCloudFrontDefaultCertificate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "cloudFrontDefaultCertificate",
        cloudFrontDefaultCertificate
      )
    def getIamCertificateId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamCertificateId", iamCertificateId)
    def getMinimumProtocolVersion: ZIO[Any, AwsError, NonEmptyString] = AwsError
      .unwrapOptionField("minimumProtocolVersion", minimumProtocolVersion)
    def getSslSupportMethod: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sslSupportMethod", sslSupportMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly {
    override val acmCertificateArn: Option[NonEmptyString] = scala
      .Option(impl.acmCertificateArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val certificate: Option[NonEmptyString] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val certificateSource: Option[NonEmptyString] = scala
      .Option(impl.certificateSource())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val cloudFrontDefaultCertificate: Option[Boolean] = scala
      .Option(impl.cloudFrontDefaultCertificate())
      .map(value => value: Boolean)
    override val iamCertificateId: Option[NonEmptyString] = scala
      .Option(impl.iamCertificateId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val minimumProtocolVersion: Option[NonEmptyString] = scala
      .Option(impl.minimumProtocolVersion())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sslSupportMethod: Option[NonEmptyString] = scala
      .Option(impl.sslSupportMethod())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionViewerCertificate
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionViewerCertificate.ReadOnly =
    new Wrapper(impl)
}
