package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginGroups(
    items: Option[
      Iterable[zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroups = {
    import AwsCloudFrontDistributionOriginGroups.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroups
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginGroups {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroups
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def items: Option[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly
    ]]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroups
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly {
    override val items: Option[List[
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup.ReadOnly
    ]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroup
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroups
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroups.ReadOnly =
    new Wrapper(impl)
}
