package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(
    items: Option[Iterable[Integer]] = None,
    quantity: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes = {
    import AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item: java.lang.Integer
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(quantity.map(value => value: java.lang.Integer))(
        _.quantity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginGroupFailoverStatusCodes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes =
      zio.aws.securityhub.model
        .AwsCloudFrontDistributionOriginGroupFailoverStatusCodes(
          items.map(value => value),
          quantity.map(value => value)
        )
    def items: Option[List[Integer]]
    def quantity: Option[Integer]
    def getItems: ZIO[Any, AwsError, List[Integer]] =
      AwsError.unwrapOptionField("items", items)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly {
    override val items: Option[List[Integer]] = scala
      .Option(impl.items())
      .map(value =>
        value.asScala.map { item =>
          item: Integer
        }.toList
      )
    override val quantity: Option[Integer] =
      scala.Option(impl.quantity()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.ReadOnly =
    new Wrapper(impl)
}
