package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateDomainValidationOption(
    domainName: Option[NonEmptyString] = None,
    resourceRecord: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord
    ] = None,
    validationDomain: Option[NonEmptyString] = None,
    validationEmails: Option[Iterable[NonEmptyString]] = None,
    validationMethod: Option[NonEmptyString] = None,
    validationStatus: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption = {
    import AwsCertificateManagerCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
      .builder()
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .optionallyWith(
        validationDomain.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationDomain)
      .optionallyWith(
        validationEmails.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.validationEmails)
      .optionallyWith(
        validationMethod.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationMethod)
      .optionallyWith(
        validationStatus.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.validationStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption =
      zio.aws.securityhub.model
        .AwsCertificateManagerCertificateDomainValidationOption(
          domainName.map(value => value),
          resourceRecord.map(value => value.asEditable),
          validationDomain.map(value => value),
          validationEmails.map(value => value),
          validationMethod.map(value => value),
          validationStatus.map(value => value)
        )
    def domainName: Option[NonEmptyString]
    def resourceRecord: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ]
    def validationDomain: Option[NonEmptyString]
    def validationEmails: Option[List[NonEmptyString]]
    def validationMethod: Option[NonEmptyString]
    def validationStatus: Option[NonEmptyString]
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getResourceRecord: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ] = AwsError.unwrapOptionField("resourceRecord", resourceRecord)
    def getValidationDomain: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationDomain", validationDomain)
    def getValidationEmails: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("validationEmails", validationEmails)
    def getValidationMethod: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationMethod", validationMethod)
    def getValidationStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly {
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceRecord: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord.ReadOnly
    ] = scala
      .Option(impl.resourceRecord())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateResourceRecord
          .wrap(value)
      )
    override val validationDomain: Option[NonEmptyString] = scala
      .Option(impl.validationDomain())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val validationEmails: Option[List[NonEmptyString]] = scala
      .Option(impl.validationEmails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val validationMethod: Option[NonEmptyString] = scala
      .Option(impl.validationMethod())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val validationStatus: Option[NonEmptyString] = scala
      .Option(impl.validationStatus())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly =
    new Wrapper(impl)
}
