package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsCertificateManagerCertificateDetails(
    certificateAuthorityArn: Option[NonEmptyString] = None,
    createdAt: Option[NonEmptyString] = None,
    domainName: Option[NonEmptyString] = None,
    domainValidationOptions: Option[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
    ]] = None,
    extendedKeyUsages: Option[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
    ]] = None,
    failureReason: Option[NonEmptyString] = None,
    importedAt: Option[NonEmptyString] = None,
    inUseBy: Option[Iterable[NonEmptyString]] = None,
    issuedAt: Option[NonEmptyString] = None,
    issuer: Option[NonEmptyString] = None,
    keyAlgorithm: Option[NonEmptyString] = None,
    keyUsages: Option[Iterable[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage
    ]] = None,
    notAfter: Option[NonEmptyString] = None,
    notBefore: Option[NonEmptyString] = None,
    options: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions
    ] = None,
    renewalEligibility: Option[NonEmptyString] = None,
    renewalSummary: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
    ] = None,
    serial: Option[NonEmptyString] = None,
    signatureAlgorithm: Option[NonEmptyString] = None,
    status: Option[NonEmptyString] = None,
    subject: Option[NonEmptyString] = None,
    subjectAlternativeNames: Option[Iterable[NonEmptyString]] = None,
    `type`: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails = {
    import AwsCertificateManagerCertificateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
      .builder()
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        domainName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsages)
      .optionallyWith(
        failureReason.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        importedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.importedAt)
      .optionallyWith(
        inUseBy.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.inUseBy)
      .optionallyWith(
        issuedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuedAt)
      .optionallyWith(
        issuer.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.issuer)
      .optionallyWith(
        keyAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyAlgorithm)
      .optionallyWith(
        keyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyUsages)
      .optionallyWith(
        notAfter.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.notAfter)
      .optionallyWith(
        notBefore.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.notBefore)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        renewalEligibility.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.renewalEligibility)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(
        serial.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.serial)
      .optionallyWith(
        signatureAlgorithm.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.signatureAlgorithm)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        subject.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subject)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails
      .wrap(buildAwsValue())
}
object AwsCertificateManagerCertificateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails =
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails(
        certificateAuthorityArn.map(value => value),
        createdAt.map(value => value),
        domainName.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failureReason.map(value => value),
        importedAt.map(value => value),
        inUseBy.map(value => value),
        issuedAt.map(value => value),
        issuer.map(value => value),
        keyAlgorithm.map(value => value),
        keyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notAfter.map(value => value),
        notBefore.map(value => value),
        options.map(value => value.asEditable),
        renewalEligibility.map(value => value),
        renewalSummary.map(value => value.asEditable),
        serial.map(value => value),
        signatureAlgorithm.map(value => value),
        status.map(value => value),
        subject.map(value => value),
        subjectAlternativeNames.map(value => value),
        `type`.map(value => value)
      )
    def certificateAuthorityArn: Option[NonEmptyString]
    def createdAt: Option[NonEmptyString]
    def domainName: Option[NonEmptyString]
    def domainValidationOptions: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]]
    def extendedKeyUsages: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]]
    def failureReason: Option[NonEmptyString]
    def importedAt: Option[NonEmptyString]
    def inUseBy: Option[List[NonEmptyString]]
    def issuedAt: Option[NonEmptyString]
    def issuer: Option[NonEmptyString]
    def keyAlgorithm: Option[NonEmptyString]
    def keyUsages: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]]
    def notAfter: Option[NonEmptyString]
    def notBefore: Option[NonEmptyString]
    def options: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ]
    def renewalEligibility: Option[NonEmptyString]
    def renewalSummary: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ]
    def serial: Option[NonEmptyString]
    def signatureAlgorithm: Option[NonEmptyString]
    def status: Option[NonEmptyString]
    def subject: Option[NonEmptyString]
    def subjectAlternativeNames: Option[List[NonEmptyString]]
    def `type`: Option[NonEmptyString]
    def getCertificateAuthorityArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "certificateAuthorityArn",
        certificateAuthorityArn
      )
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDomainName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getExtendedKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsages", extendedKeyUsages)
    def getFailureReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getImportedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("importedAt", importedAt)
    def getInUseBy: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("inUseBy", inUseBy)
    def getIssuedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getIssuer: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getKeyAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("keyUsages", keyUsages)
    def getNotAfter: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getNotBefore: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getRenewalEligibility: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("renewalEligibility", renewalEligibility)
    def getRenewalSummary: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ] = AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getSerial: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("serial", serial)
    def getSignatureAlgorithm: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getSubject: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subject", subject)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ) extends zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly {
    override val certificateAuthorityArn: Option[NonEmptyString] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdAt: Option[NonEmptyString] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainName: Option[NonEmptyString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val domainValidationOptions: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption.ReadOnly
    ]] = scala
      .Option(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
    override val extendedKeyUsages: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage.ReadOnly
    ]] = scala
      .Option(impl.extendedKeyUsages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateExtendedKeyUsage
            .wrap(item)
        }.toList
      )
    override val failureReason: Option[NonEmptyString] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val importedAt: Option[NonEmptyString] = scala
      .Option(impl.importedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val inUseBy: Option[List[NonEmptyString]] = scala
      .Option(impl.inUseBy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val issuedAt: Option[NonEmptyString] = scala
      .Option(impl.issuedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val issuer: Option[NonEmptyString] = scala
      .Option(impl.issuer())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyAlgorithm: Option[NonEmptyString] = scala
      .Option(impl.keyAlgorithm())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keyUsages: Option[List[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage.ReadOnly
    ]] = scala
      .Option(impl.keyUsages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsCertificateManagerCertificateKeyUsage
            .wrap(item)
        }.toList
      )
    override val notAfter: Option[NonEmptyString] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val notBefore: Option[NonEmptyString] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val options: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions.ReadOnly
    ] = scala
      .Option(impl.options())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateOptions
          .wrap(value)
      )
    override val renewalEligibility: Option[NonEmptyString] = scala
      .Option(impl.renewalEligibility())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val renewalSummary: Option[
      zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary.ReadOnly
    ] = scala
      .Option(impl.renewalSummary())
      .map(value =>
        zio.aws.securityhub.model.AwsCertificateManagerCertificateRenewalSummary
          .wrap(value)
      )
    override val serial: Option[NonEmptyString] = scala
      .Option(impl.serial())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val signatureAlgorithm: Option[NonEmptyString] = scala
      .Option(impl.signatureAlgorithm())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val status: Option[NonEmptyString] = scala
      .Option(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subject: Option[NonEmptyString] = scala
      .Option(impl.subject())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subjectAlternativeNames: Option[List[NonEmptyString]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val `type`: Option[NonEmptyString] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCertificateManagerCertificateDetails
  ): zio.aws.securityhub.model.AwsCertificateManagerCertificateDetails.ReadOnly =
    new Wrapper(impl)
}
