package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(
    launchTemplateSpecification: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
    ] = None,
    overrides: Option[Iterable[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails = {
    import AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails =
      zio.aws.securityhub.model
        .AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(
          launchTemplateSpecification.map(value => value.asEditable),
          overrides.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def launchTemplateSpecification: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ]
    def overrides: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly {
    override val launchTemplateSpecification: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.ReadOnly
    ] = scala
      .Option(impl.launchTemplateSpecification())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
          .wrap(value)
      )
    override val overrides: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.ReadOnly
    ]] = scala
      .Option(impl.overrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.ReadOnly =
    new Wrapper(impl)
}
