package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingAutoScalingGroupDetails(
    launchConfigurationName: Option[NonEmptyString] = None,
    loadBalancerNames: Option[Iterable[NonEmptyString]] = None,
    healthCheckType: Option[NonEmptyString] = None,
    healthCheckGracePeriod: Option[Integer] = None,
    createdTime: Option[NonEmptyString] = None,
    mixedInstancesPolicy: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
    ] = None,
    availabilityZones: Option[Iterable[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails = {
    import AwsAutoScalingAutoScalingGroupDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
      .builder()
      .optionallyWith(
        launchConfigurationName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchConfigurationName)
      .optionallyWith(
        loadBalancerNames.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loadBalancerNames)
      .optionallyWith(
        healthCheckType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.healthCheckType)
      .optionallyWith(
        healthCheckGracePeriod.map(value => value: java.lang.Integer)
      )(_.healthCheckGracePeriod)
      .optionallyWith(
        createdTime.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdTime)
      .optionallyWith(mixedInstancesPolicy.map(value => value.buildAwsValue()))(
        _.mixedInstancesPolicy
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
      .wrap(buildAwsValue())
}
object AwsAutoScalingAutoScalingGroupDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails =
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails(
        launchConfigurationName.map(value => value),
        loadBalancerNames.map(value => value),
        healthCheckType.map(value => value),
        healthCheckGracePeriod.map(value => value),
        createdTime.map(value => value),
        mixedInstancesPolicy.map(value => value.asEditable),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchConfigurationName: Option[NonEmptyString]
    def loadBalancerNames: Option[List[NonEmptyString]]
    def healthCheckType: Option[NonEmptyString]
    def healthCheckGracePeriod: Option[Integer]
    def createdTime: Option[NonEmptyString]
    def mixedInstancesPolicy: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly
    ]
    def availabilityZones: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly
    ]]
    def getLaunchConfigurationName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "launchConfigurationName",
        launchConfigurationName
      )
    def getLoadBalancerNames: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("loadBalancerNames", loadBalancerNames)
    def getHealthCheckType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("healthCheckType", healthCheckType)
    def getHealthCheckGracePeriod: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("healthCheckGracePeriod", healthCheckGracePeriod)
    def getCreatedTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getMixedInstancesPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("mixedInstancesPolicy", mixedInstancesPolicy)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
  ) extends zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly {
    override val launchConfigurationName: Option[NonEmptyString] = scala
      .Option(impl.launchConfigurationName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val loadBalancerNames: Option[List[NonEmptyString]] = scala
      .Option(impl.loadBalancerNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val healthCheckType: Option[NonEmptyString] = scala
      .Option(impl.healthCheckType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val healthCheckGracePeriod: Option[Integer] =
      scala.Option(impl.healthCheckGracePeriod()).map(value => value: Integer)
    override val createdTime: Option[NonEmptyString] = scala
      .Option(impl.createdTime())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val mixedInstancesPolicy: Option[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.ReadOnly
    ] = scala
      .Option(impl.mixedInstancesPolicy())
      .map(value =>
        zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails
          .wrap(value)
      )
    override val availabilityZones: Option[List[
      zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.ReadOnly
    ]] = scala
      .Option(impl.availabilityZones())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupDetails
  ): zio.aws.securityhub.model.AwsAutoScalingAutoScalingGroupDetails.ReadOnly =
    new Wrapper(impl)
}
