package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountDetails(
    accountId: AccountId,
    email: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AccountDetails = {
    import AccountDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AccountDetails
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(
        email.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.email)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AccountDetails.ReadOnly =
    zio.aws.securityhub.model.AccountDetails.wrap(buildAwsValue())
}
object AccountDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AccountDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AccountDetails =
      zio.aws.securityhub.model
        .AccountDetails(accountId, email.map(value => value))
    def accountId: AccountId
    def email: Option[NonEmptyString]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getEmail: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("email", email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AccountDetails
  ) extends zio.aws.securityhub.model.AccountDetails.ReadOnly {
    override val accountId: AccountId =
      zio.aws.securityhub.model.primitives.AccountId(impl.accountId())
    override val email: Option[NonEmptyString] = scala
      .Option(impl.email())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AccountDetails
  ): zio.aws.securityhub.model.AccountDetails.ReadOnly = new Wrapper(impl)
}
