package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StatusReason(
    reasonCode: NonEmptyString,
    description: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.StatusReason = {
    import StatusReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.StatusReason
      .builder()
      .reasonCode(NonEmptyString.unwrap(reasonCode): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.StatusReason.ReadOnly =
    zio.aws.securityhub.model.StatusReason.wrap(buildAwsValue())
}
object StatusReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.StatusReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.StatusReason =
      zio.aws.securityhub.model
        .StatusReason(reasonCode, description.map(value => value))
    def reasonCode: NonEmptyString
    def description: Option[NonEmptyString]
    def getReasonCode: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(reasonCode)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.StatusReason
  ) extends zio.aws.securityhub.model.StatusReason.ReadOnly {
    override val reasonCode: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.reasonCode())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.StatusReason
  ): zio.aws.securityhub.model.StatusReason.ReadOnly = new Wrapper(impl)
}
